/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.launchwizard.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.launchwizard.model.DeploymentStatus;
import com.amazonaws.services.launchwizard.model.transform.DeploymentDataMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DeploymentData
implements Serializable,
Cloneable,
StructuredPojo {
    private Date createdAt;
    private Date deletedAt;
    private String deploymentArn;
    private String id;
    private String name;
    private String patternName;
    private String resourceGroup;
    private Map<String, String> specifications;
    private String status;
    private Map<String, String> tags;
    private String workloadName;

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public DeploymentData withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setDeletedAt(Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    public Date getDeletedAt() {
        return this.deletedAt;
    }

    public DeploymentData withDeletedAt(Date deletedAt) {
        this.setDeletedAt(deletedAt);
        return this;
    }

    public void setDeploymentArn(String deploymentArn) {
        this.deploymentArn = deploymentArn;
    }

    public String getDeploymentArn() {
        return this.deploymentArn;
    }

    public DeploymentData withDeploymentArn(String deploymentArn) {
        this.setDeploymentArn(deploymentArn);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public DeploymentData withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentData withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPatternName(String patternName) {
        this.patternName = patternName;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public DeploymentData withPatternName(String patternName) {
        this.setPatternName(patternName);
        return this;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public DeploymentData withResourceGroup(String resourceGroup) {
        this.setResourceGroup(resourceGroup);
        return this;
    }

    public Map<String, String> getSpecifications() {
        return this.specifications;
    }

    public void setSpecifications(Map<String, String> specifications) {
        this.specifications = specifications;
    }

    public DeploymentData withSpecifications(Map<String, String> specifications) {
        this.setSpecifications(specifications);
        return this;
    }

    public DeploymentData addSpecificationsEntry(String key, String value) {
        if (null == this.specifications) {
            this.specifications = new HashMap<String, String>();
        }
        if (this.specifications.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.specifications.put(key, value);
        return this;
    }

    public DeploymentData clearSpecificationsEntries() {
        this.specifications = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DeploymentData withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DeploymentData withStatus(DeploymentStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public DeploymentData withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public DeploymentData addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public DeploymentData clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setWorkloadName(String workloadName) {
        this.workloadName = workloadName;
    }

    public String getWorkloadName() {
        return this.workloadName;
    }

    public DeploymentData withWorkloadName(String workloadName) {
        this.setWorkloadName(workloadName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getDeletedAt() != null) {
            sb.append("DeletedAt: ").append(this.getDeletedAt()).append(",");
        }
        if (this.getDeploymentArn() != null) {
            sb.append("DeploymentArn: ").append(this.getDeploymentArn()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPatternName() != null) {
            sb.append("PatternName: ").append(this.getPatternName()).append(",");
        }
        if (this.getResourceGroup() != null) {
            sb.append("ResourceGroup: ").append(this.getResourceGroup()).append(",");
        }
        if (this.getSpecifications() != null) {
            sb.append("Specifications: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWorkloadName() != null) {
            sb.append("WorkloadName: ").append(this.getWorkloadName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentData)) {
            return false;
        }
        DeploymentData other = (DeploymentData)obj;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getDeletedAt() == null ^ this.getDeletedAt() == null) {
            return false;
        }
        if (other.getDeletedAt() != null && !other.getDeletedAt().equals(this.getDeletedAt())) {
            return false;
        }
        if (other.getDeploymentArn() == null ^ this.getDeploymentArn() == null) {
            return false;
        }
        if (other.getDeploymentArn() != null && !other.getDeploymentArn().equals(this.getDeploymentArn())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPatternName() == null ^ this.getPatternName() == null) {
            return false;
        }
        if (other.getPatternName() != null && !other.getPatternName().equals(this.getPatternName())) {
            return false;
        }
        if (other.getResourceGroup() == null ^ this.getResourceGroup() == null) {
            return false;
        }
        if (other.getResourceGroup() != null && !other.getResourceGroup().equals(this.getResourceGroup())) {
            return false;
        }
        if (other.getSpecifications() == null ^ this.getSpecifications() == null) {
            return false;
        }
        if (other.getSpecifications() != null && !other.getSpecifications().equals(this.getSpecifications())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWorkloadName() == null ^ this.getWorkloadName() == null) {
            return false;
        }
        return other.getWorkloadName() == null || other.getWorkloadName().equals(this.getWorkloadName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDeletedAt() == null ? 0 : this.getDeletedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentArn() == null ? 0 : this.getDeploymentArn().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPatternName() == null ? 0 : this.getPatternName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceGroup() == null ? 0 : this.getResourceGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSpecifications() == null ? 0 : this.getSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadName() == null ? 0 : this.getWorkloadName().hashCode());
        return hashCode;
    }

    public DeploymentData clone() {
        try {
            return (DeploymentData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

