/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kms.model;

import java.io.Serializable;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKey" target="_top">AWS API
 *      Documentation</a>
 */
public class CreateKeyResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Metadata associated with the CMK.
     * </p>
     */
    private KeyMetadata keyMetadata;

    /**
     * <p>
     * Metadata associated with the CMK.
     * </p>
     * 
     * @param keyMetadata
     *        Metadata associated with the CMK.
     */

    public void setKeyMetadata(KeyMetadata keyMetadata) {
        this.keyMetadata = keyMetadata;
    }

    /**
     * <p>
     * Metadata associated with the CMK.
     * </p>
     * 
     * @return Metadata associated with the CMK.
     */

    public KeyMetadata getKeyMetadata() {
        return this.keyMetadata;
    }

    /**
     * <p>
     * Metadata associated with the CMK.
     * </p>
     * 
     * @param keyMetadata
     *        Metadata associated with the CMK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateKeyResult withKeyMetadata(KeyMetadata keyMetadata) {
        setKeyMetadata(keyMetadata);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKeyMetadata() != null)
            sb.append("KeyMetadata: ").append(getKeyMetadata());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateKeyResult == false)
            return false;
        CreateKeyResult other = (CreateKeyResult) obj;
        if (other.getKeyMetadata() == null ^ this.getKeyMetadata() == null)
            return false;
        if (other.getKeyMetadata() != null && other.getKeyMetadata().equals(this.getKeyMetadata()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKeyMetadata() == null) ? 0 : getKeyMetadata().hashCode());
        return hashCode;
    }

    @Override
    public CreateKeyResult clone() {
        try {
            return (CreateKeyResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
