/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoClientBuilder;
import com.amazonaws.services.kinesisvideo.model.AmazonKinesisVideoException;
import com.amazonaws.services.kinesisvideo.model.CreateSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.CreateSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.CreateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.CreateStreamResult;
import com.amazonaws.services.kinesisvideo.model.DeleteSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamResult;
import com.amazonaws.services.kinesisvideo.model.DescribeEdgeConfigurationRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeEdgeConfigurationResult;
import com.amazonaws.services.kinesisvideo.model.DescribeImageGenerationConfigurationRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeImageGenerationConfigurationResult;
import com.amazonaws.services.kinesisvideo.model.DescribeNotificationConfigurationRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeNotificationConfigurationResult;
import com.amazonaws.services.kinesisvideo.model.DescribeSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamResult;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointResult;
import com.amazonaws.services.kinesisvideo.model.GetSignalingChannelEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetSignalingChannelEndpointResult;
import com.amazonaws.services.kinesisvideo.model.ListSignalingChannelsRequest;
import com.amazonaws.services.kinesisvideo.model.ListSignalingChannelsResult;
import com.amazonaws.services.kinesisvideo.model.ListStreamsRequest;
import com.amazonaws.services.kinesisvideo.model.ListStreamsResult;
import com.amazonaws.services.kinesisvideo.model.ListTagsForResourceRequest;
import com.amazonaws.services.kinesisvideo.model.ListTagsForResourceResult;
import com.amazonaws.services.kinesisvideo.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesisvideo.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesisvideo.model.StartEdgeConfigurationUpdateRequest;
import com.amazonaws.services.kinesisvideo.model.StartEdgeConfigurationUpdateResult;
import com.amazonaws.services.kinesisvideo.model.TagResourceRequest;
import com.amazonaws.services.kinesisvideo.model.TagResourceResult;
import com.amazonaws.services.kinesisvideo.model.TagStreamRequest;
import com.amazonaws.services.kinesisvideo.model.TagStreamResult;
import com.amazonaws.services.kinesisvideo.model.UntagResourceRequest;
import com.amazonaws.services.kinesisvideo.model.UntagResourceResult;
import com.amazonaws.services.kinesisvideo.model.UntagStreamRequest;
import com.amazonaws.services.kinesisvideo.model.UntagStreamResult;
import com.amazonaws.services.kinesisvideo.model.UpdateDataRetentionRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateDataRetentionResult;
import com.amazonaws.services.kinesisvideo.model.UpdateImageGenerationConfigurationRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateImageGenerationConfigurationResult;
import com.amazonaws.services.kinesisvideo.model.UpdateNotificationConfigurationRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateNotificationConfigurationResult;
import com.amazonaws.services.kinesisvideo.model.UpdateSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.UpdateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateStreamResult;
import com.amazonaws.services.kinesisvideo.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.AccountChannelLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.AccountStreamLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ClientLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.CreateSignalingChannelRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.CreateSignalingChannelResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.CreateStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.CreateStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DeleteSignalingChannelRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DeleteSignalingChannelResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DeleteStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DeleteStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeEdgeConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeEdgeConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeImageGenerationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeImageGenerationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeNotificationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeNotificationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeSignalingChannelRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeSignalingChannelResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DescribeStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.DeviceStreamLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetDataEndpointRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetDataEndpointResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetSignalingChannelEndpointRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetSignalingChannelEndpointResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.InvalidArgumentExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.InvalidDeviceExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.InvalidResourceFormatExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListSignalingChannelsRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListSignalingChannelsResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListStreamsRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListStreamsResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListTagsForStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListTagsForStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.NoDataRetentionExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.StartEdgeConfigurationUpdateRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.StartEdgeConfigurationUpdateResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.StreamEdgeConfigurationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagsPerResourceExceededLimitExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UntagStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UntagStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateDataRetentionRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateDataRetentionResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateImageGenerationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateImageGenerationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateNotificationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateNotificationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateSignalingChannelRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateSignalingChannelResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UpdateStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.VersionMismatchExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisVideoClient
extends AmazonWebServiceClient
implements AmazonKinesisVideo {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesisVideo.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesisvideo";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountStreamLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccountStreamLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("VersionMismatchException").withExceptionUnmarshaller((JsonErrorUnmarshaller)VersionMismatchExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountChannelLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccountChannelLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ClientLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StreamEdgeConfigurationNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)StreamEdgeConfigurationNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceFormatException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidResourceFormatExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidArgumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoDataRetentionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NoDataRetentionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidDeviceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidDeviceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagsPerResourceExceededLimitException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TagsPerResourceExceededLimitExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DeviceStreamLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DeviceStreamLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotAuthorizedExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonKinesisVideoException.class));

    public static AmazonKinesisVideoClientBuilder builder() {
        return AmazonKinesisVideoClientBuilder.standard();
    }

    AmazonKinesisVideoClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonKinesisVideoClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("kinesisvideo.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesisvideo/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesisvideo/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateSignalingChannelResult createSignalingChannel(CreateSignalingChannelRequest request) {
        request = (CreateSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateSignalingChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSignalingChannelResult executeCreateSignalingChannel(CreateSignalingChannelRequest createSignalingChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSignalingChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSignalingChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSignalingChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateSignalingChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSignalingChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSignalingChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSignalingChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSignalingChannelResult createSignalingChannelResult = (CreateSignalingChannelResult)response.getAwsResponse();
            return createSignalingChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStreamResult createStream(CreateStreamRequest request) {
        request = (CreateStreamRequest)this.beforeClientExecution(request);
        return this.executeCreateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStreamResult executeCreateStream(CreateStreamRequest createStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStreamRequestProtocolMarshaller(protocolFactory).marshall((CreateStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStreamResult createStreamResult = (CreateStreamResult)response.getAwsResponse();
            return createStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSignalingChannelResult deleteSignalingChannel(DeleteSignalingChannelRequest request) {
        request = (DeleteSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteSignalingChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSignalingChannelResult executeDeleteSignalingChannel(DeleteSignalingChannelRequest deleteSignalingChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSignalingChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSignalingChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSignalingChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteSignalingChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSignalingChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSignalingChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSignalingChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSignalingChannelResult deleteSignalingChannelResult = (DeleteSignalingChannelResult)response.getAwsResponse();
            return deleteSignalingChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStreamResult deleteStream(DeleteStreamRequest request) {
        request = (DeleteStreamRequest)this.beforeClientExecution(request);
        return this.executeDeleteStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStreamResult executeDeleteStream(DeleteStreamRequest deleteStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStreamRequestProtocolMarshaller(protocolFactory).marshall((DeleteStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStreamResult deleteStreamResult = (DeleteStreamResult)response.getAwsResponse();
            return deleteStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEdgeConfigurationResult describeEdgeConfiguration(DescribeEdgeConfigurationRequest request) {
        request = (DescribeEdgeConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeEdgeConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEdgeConfigurationResult executeDescribeEdgeConfiguration(DescribeEdgeConfigurationRequest describeEdgeConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEdgeConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEdgeConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEdgeConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeEdgeConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEdgeConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEdgeConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEdgeConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEdgeConfigurationResult describeEdgeConfigurationResult = (DescribeEdgeConfigurationResult)response.getAwsResponse();
            return describeEdgeConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeImageGenerationConfigurationResult describeImageGenerationConfiguration(DescribeImageGenerationConfigurationRequest request) {
        request = (DescribeImageGenerationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeImageGenerationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeImageGenerationConfigurationResult executeDescribeImageGenerationConfiguration(DescribeImageGenerationConfigurationRequest describeImageGenerationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeImageGenerationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeImageGenerationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeImageGenerationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeImageGenerationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeImageGenerationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeImageGenerationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeImageGenerationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeImageGenerationConfigurationResult describeImageGenerationConfigurationResult = (DescribeImageGenerationConfigurationResult)response.getAwsResponse();
            return describeImageGenerationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNotificationConfigurationResult describeNotificationConfiguration(DescribeNotificationConfigurationRequest request) {
        request = (DescribeNotificationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeNotificationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNotificationConfigurationResult executeDescribeNotificationConfiguration(DescribeNotificationConfigurationRequest describeNotificationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNotificationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNotificationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeNotificationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNotificationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeNotificationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotificationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNotificationConfigurationResult describeNotificationConfigurationResult = (DescribeNotificationConfigurationResult)response.getAwsResponse();
            return describeNotificationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSignalingChannelResult describeSignalingChannel(DescribeSignalingChannelRequest request) {
        request = (DescribeSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executeDescribeSignalingChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSignalingChannelResult executeDescribeSignalingChannel(DescribeSignalingChannelRequest describeSignalingChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSignalingChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSignalingChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSignalingChannelRequestProtocolMarshaller(protocolFactory).marshall((DescribeSignalingChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSignalingChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSignalingChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSignalingChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSignalingChannelResult describeSignalingChannelResult = (DescribeSignalingChannelResult)response.getAwsResponse();
            return describeSignalingChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeStreamResult describeStream(DescribeStreamRequest request) {
        request = (DescribeStreamRequest)this.beforeClientExecution(request);
        return this.executeDescribeStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeStreamResult executeDescribeStream(DescribeStreamRequest describeStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStreamRequestProtocolMarshaller(protocolFactory).marshall((DescribeStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStreamResult describeStreamResult = (DescribeStreamResult)response.getAwsResponse();
            return describeStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataEndpointResult getDataEndpoint(GetDataEndpointRequest request) {
        request = (GetDataEndpointRequest)this.beforeClientExecution(request);
        return this.executeGetDataEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataEndpointResult executeGetDataEndpoint(GetDataEndpointRequest getDataEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataEndpointRequestProtocolMarshaller(protocolFactory).marshall((GetDataEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataEndpointResult getDataEndpointResult = (GetDataEndpointResult)response.getAwsResponse();
            return getDataEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSignalingChannelEndpointResult getSignalingChannelEndpoint(GetSignalingChannelEndpointRequest request) {
        request = (GetSignalingChannelEndpointRequest)this.beforeClientExecution(request);
        return this.executeGetSignalingChannelEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSignalingChannelEndpointResult executeGetSignalingChannelEndpoint(GetSignalingChannelEndpointRequest getSignalingChannelEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSignalingChannelEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSignalingChannelEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSignalingChannelEndpointRequestProtocolMarshaller(protocolFactory).marshall((GetSignalingChannelEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSignalingChannelEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSignalingChannelEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSignalingChannelEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSignalingChannelEndpointResult getSignalingChannelEndpointResult = (GetSignalingChannelEndpointResult)response.getAwsResponse();
            return getSignalingChannelEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSignalingChannelsResult listSignalingChannels(ListSignalingChannelsRequest request) {
        request = (ListSignalingChannelsRequest)this.beforeClientExecution(request);
        return this.executeListSignalingChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSignalingChannelsResult executeListSignalingChannels(ListSignalingChannelsRequest listSignalingChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSignalingChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSignalingChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSignalingChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListSignalingChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSignalingChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSignalingChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSignalingChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSignalingChannelsResult listSignalingChannelsResult = (ListSignalingChannelsResult)response.getAwsResponse();
            return listSignalingChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest request) {
        request = (ListStreamsRequest)this.beforeClientExecution(request);
        return this.executeListStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamsResult executeListStreams(ListStreamsRequest listStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamsRequestProtocolMarshaller(protocolFactory).marshall((ListStreamsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStreams");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamsResult listStreamsResult = (ListStreamsResult)response.getAwsResponse();
            return listStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest request) {
        request = (ListTagsForStreamRequest)this.beforeClientExecution(request);
        return this.executeListTagsForStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForStreamResult executeListTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForStreamRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForStreamResult listTagsForStreamResult = (ListTagsForStreamResult)response.getAwsResponse();
            return listTagsForStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartEdgeConfigurationUpdateResult startEdgeConfigurationUpdate(StartEdgeConfigurationUpdateRequest request) {
        request = (StartEdgeConfigurationUpdateRequest)this.beforeClientExecution(request);
        return this.executeStartEdgeConfigurationUpdate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartEdgeConfigurationUpdateResult executeStartEdgeConfigurationUpdate(StartEdgeConfigurationUpdateRequest startEdgeConfigurationUpdateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startEdgeConfigurationUpdateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartEdgeConfigurationUpdateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartEdgeConfigurationUpdateRequestProtocolMarshaller(protocolFactory).marshall((StartEdgeConfigurationUpdateRequest)super.beforeMarshalling((AmazonWebServiceRequest)startEdgeConfigurationUpdateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartEdgeConfigurationUpdate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartEdgeConfigurationUpdateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartEdgeConfigurationUpdateResult startEdgeConfigurationUpdateResult = (StartEdgeConfigurationUpdateResult)response.getAwsResponse();
            return startEdgeConfigurationUpdateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagStreamResult tagStream(TagStreamRequest request) {
        request = (TagStreamRequest)this.beforeClientExecution(request);
        return this.executeTagStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagStreamResult executeTagStream(TagStreamRequest tagStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagStreamRequestProtocolMarshaller(protocolFactory).marshall((TagStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagStreamResult tagStreamResult = (TagStreamResult)response.getAwsResponse();
            return tagStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagStreamResult untagStream(UntagStreamRequest request) {
        request = (UntagStreamRequest)this.beforeClientExecution(request);
        return this.executeUntagStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagStreamResult executeUntagStream(UntagStreamRequest untagStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagStreamRequestProtocolMarshaller(protocolFactory).marshall((UntagStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagStreamResult untagStreamResult = (UntagStreamResult)response.getAwsResponse();
            return untagStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataRetentionResult updateDataRetention(UpdateDataRetentionRequest request) {
        request = (UpdateDataRetentionRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataRetention(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataRetentionResult executeUpdateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataRetentionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataRetentionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataRetentionRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataRetentionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataRetentionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataRetention");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataRetentionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataRetentionResult updateDataRetentionResult = (UpdateDataRetentionResult)response.getAwsResponse();
            return updateDataRetentionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateImageGenerationConfigurationResult updateImageGenerationConfiguration(UpdateImageGenerationConfigurationRequest request) {
        request = (UpdateImageGenerationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateImageGenerationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateImageGenerationConfigurationResult executeUpdateImageGenerationConfiguration(UpdateImageGenerationConfigurationRequest updateImageGenerationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateImageGenerationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateImageGenerationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateImageGenerationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateImageGenerationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateImageGenerationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateImageGenerationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateImageGenerationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateImageGenerationConfigurationResult updateImageGenerationConfigurationResult = (UpdateImageGenerationConfigurationResult)response.getAwsResponse();
            return updateImageGenerationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNotificationConfigurationResult updateNotificationConfiguration(UpdateNotificationConfigurationRequest request) {
        request = (UpdateNotificationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateNotificationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNotificationConfigurationResult executeUpdateNotificationConfiguration(UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNotificationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNotificationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNotificationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateNotificationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNotificationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNotificationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotificationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNotificationConfigurationResult updateNotificationConfigurationResult = (UpdateNotificationConfigurationResult)response.getAwsResponse();
            return updateNotificationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSignalingChannelResult updateSignalingChannel(UpdateSignalingChannelRequest request) {
        request = (UpdateSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateSignalingChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSignalingChannelResult executeUpdateSignalingChannel(UpdateSignalingChannelRequest updateSignalingChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSignalingChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSignalingChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSignalingChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateSignalingChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSignalingChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSignalingChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSignalingChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSignalingChannelResult updateSignalingChannelResult = (UpdateSignalingChannelResult)response.getAwsResponse();
            return updateSignalingChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateStreamResult updateStream(UpdateStreamRequest request) {
        request = (UpdateStreamRequest)this.beforeClientExecution(request);
        return this.executeUpdateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateStreamResult executeUpdateStream(UpdateStreamRequest updateStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateStreamRequestProtocolMarshaller(protocolFactory).marshall((UpdateStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateStreamResult updateStreamResult = (UpdateStreamResult)response.getAwsResponse();
            return updateStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

