/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

public final class AckErrorCode {
    private final Values enumValue;
    private final String rawValue;

    private AckErrorCode(Values enumValue, String rawValue) {
        this.enumValue = enumValue;
        this.rawValue = rawValue;
    }

    public static AckErrorCode of(String value) {
        return value == null ? null : new AckErrorCode(Values.fromValue(value), value);
    }

    public static AckErrorCode of(Values value) {
        if (value == Values.SDK_UNKNOWN) {
            throw new IllegalArgumentException("SDK_UNKNOWN cannot be used to create an AckErrorCode. Use the raw value tocreate an AckErrorCode from a string instead");
        }
        return value == null ? null : new AckErrorCode(value, value.toString());
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public Values getEnumValue() {
        return this.enumValue;
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AckErrorCode that = (AckErrorCode)o;
        return this.rawValue != null ? this.rawValue.equals(that.rawValue) : that.rawValue == null;
    }

    public int hashCode() {
        return this.rawValue != null ? this.rawValue.hashCode() : 0;
    }

    public static enum Values {
        STREAM_READ_ERROR("STREAM_READ_ERROR"),
        MAX_FRAGMENT_SIZE_REACHED("MAX_FRAGMENT_SIZE_REACHED"),
        MAX_FRAGMENT_DURATION_REACHED("MAX_FRAGMENT_DURATION_REACHED"),
        MAX_CONNECTION_DURATION_REACHED("MAX_CONNECTION_DURATION_REACHED"),
        FRAGMENT_TIMECODE_LESSER_THAN_PREVIOUS("FRAGMENT_TIMECODE_LESSER_THAN_PREVIOUS"),
        MORE_THAN_ONE_TRACK_FOUND("MORE_THAN_ONE_TRACK_FOUND"),
        INVALID_MKV_DATA("INVALID_MKV_DATA"),
        INVALID_PRODUCER_TIMESTAMP("INVALID_PRODUCER_TIMESTAMP"),
        STREAM_NOT_ACTIVE("STREAM_NOT_ACTIVE"),
        STREAM_DELETED("STREAM_DELETED"),
        KMS_KEY_ACCESS_DENIED("KMS_KEY_ACCESS_DENIED"),
        KMS_KEY_DISABLED("KMS_KEY_DISABLED"),
        KMS_KEY_VALIDATION_ERROR("KMS_KEY_VALIDATION_ERROR"),
        KMS_KEY_UNAVAILABLE("KMS_KEY_UNAVAILABLE"),
        KMS_KEY_INVALID_USAGE("KMS_KEY_INVALID_USAGE"),
        KMS_KEY_INVALID_STATE("KMS_KEY_INVALID_STATE"),
        KMS_KEY_NOT_FOUND("KMS_KEY_NOT_FOUND"),
        ARCHIVAL_ERROR("ARCHIVAL_ERROR"),
        INTERNAL_ERROR("INTERNAL_ERROR"),
        SDK_UNKNOWN(null);

        private final String value;

        private Values(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        private static Values fromValue(String value) {
            if (value == null || "".equals(value)) {
                throw new IllegalArgumentException("Value cannot be null or empty!");
            }
            for (Values enumEntry : Values.values()) {
                if (!value.equals(enumEntry.toString())) continue;
                return enumEntry;
            }
            return SDK_UNKNOWN;
        }
    }
}

