/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchDestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ExtendedS3DestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateDeliveryStreamRequestMarshaller
implements Marshaller<Request<CreateDeliveryStreamRequest>, CreateDeliveryStreamRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateDeliveryStreamRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateDeliveryStreamRequest> marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest) {
        if (createDeliveryStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeliveryStreamRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.CreateDeliveryStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeliveryStreamRequest.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(createDeliveryStreamRequest.getDeliveryStreamName());
            }
            if (createDeliveryStreamRequest.getS3DestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("S3DestinationConfiguration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getS3DestinationConfiguration(), jsonGenerator);
            }
            if (createDeliveryStreamRequest.getExtendedS3DestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("ExtendedS3DestinationConfiguration");
                ExtendedS3DestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getExtendedS3DestinationConfiguration(), jsonGenerator);
            }
            if (createDeliveryStreamRequest.getRedshiftDestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("RedshiftDestinationConfiguration");
                RedshiftDestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getRedshiftDestinationConfiguration(), jsonGenerator);
            }
            if (createDeliveryStreamRequest.getElasticsearchDestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("ElasticsearchDestinationConfiguration");
                ElasticsearchDestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getElasticsearchDestinationConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

