/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DisableEnhancedMonitoringRequestMarshaller
implements Marshaller<Request<DisableEnhancedMonitoringRequest>, DisableEnhancedMonitoringRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DisableEnhancedMonitoringRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DisableEnhancedMonitoringRequest> marshall(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        if (disableEnhancedMonitoringRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableEnhancedMonitoringRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.DisableEnhancedMonitoring");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList shardLevelMetricsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disableEnhancedMonitoringRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(disableEnhancedMonitoringRequest.getStreamName());
            }
            if (!(shardLevelMetricsList = (SdkInternalList)disableEnhancedMonitoringRequest.getShardLevelMetrics()).isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue == null) continue;
                    jsonGenerator.writeValue(shardLevelMetricsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

