/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.Input;
import com.amazonaws.services.kinesisanalytics.model.transform.InputParallelismJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseInputJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsInputJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.SourceSchemaJsonMarshaller;

public class InputJsonMarshaller {
    private static InputJsonMarshaller instance;

    public void marshall(Input input, StructuredJsonGenerator jsonGenerator) {
        if (input == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (input.getNamePrefix() != null) {
                jsonGenerator.writeFieldName("NamePrefix").writeValue(input.getNamePrefix());
            }
            if (input.getKinesisStreamsInput() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsInput");
                KinesisStreamsInputJsonMarshaller.getInstance().marshall(input.getKinesisStreamsInput(), jsonGenerator);
            }
            if (input.getKinesisFirehoseInput() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseInput");
                KinesisFirehoseInputJsonMarshaller.getInstance().marshall(input.getKinesisFirehoseInput(), jsonGenerator);
            }
            if (input.getInputParallelism() != null) {
                jsonGenerator.writeFieldName("InputParallelism");
                InputParallelismJsonMarshaller.getInstance().marshall(input.getInputParallelism(), jsonGenerator);
            }
            if (input.getInputSchema() != null) {
                jsonGenerator.writeFieldName("InputSchema");
                SourceSchemaJsonMarshaller.getInstance().marshall(input.getInputSchema(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputJsonMarshaller();
        }
        return instance;
    }
}

