/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaRequest;
import com.amazonaws.services.kinesisanalytics.model.transform.InputStartingPositionConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DiscoverInputSchemaRequestMarshaller
implements Marshaller<Request<DiscoverInputSchemaRequest>, DiscoverInputSchemaRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DiscoverInputSchemaRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DiscoverInputSchemaRequest> marshall(DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        if (discoverInputSchemaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)discoverInputSchemaRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.DiscoverInputSchema");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (discoverInputSchemaRequest.getResourceARN() != null) {
                jsonGenerator.writeFieldName("ResourceARN").writeValue(discoverInputSchemaRequest.getResourceARN());
            }
            if (discoverInputSchemaRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(discoverInputSchemaRequest.getRoleARN());
            }
            if (discoverInputSchemaRequest.getInputStartingPositionConfiguration() != null) {
                jsonGenerator.writeFieldName("InputStartingPositionConfiguration");
                InputStartingPositionConfigurationJsonMarshaller.getInstance().marshall(discoverInputSchemaRequest.getInputStartingPositionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

