/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.S3ReferenceDataSource;

public class S3ReferenceDataSourceJsonMarshaller {
    private static S3ReferenceDataSourceJsonMarshaller instance;

    public void marshall(S3ReferenceDataSource s3ReferenceDataSource, StructuredJsonGenerator jsonGenerator) {
        if (s3ReferenceDataSource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3ReferenceDataSource.getBucketARN() != null) {
                jsonGenerator.writeFieldName("BucketARN").writeValue(s3ReferenceDataSource.getBucketARN());
            }
            if (s3ReferenceDataSource.getFileKey() != null) {
                jsonGenerator.writeFieldName("FileKey").writeValue(s3ReferenceDataSource.getFileKey());
            }
            if (s3ReferenceDataSource.getReferenceRoleARN() != null) {
                jsonGenerator.writeFieldName("ReferenceRoleARN").writeValue(s3ReferenceDataSource.getReferenceRoleARN());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3ReferenceDataSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3ReferenceDataSourceJsonMarshaller();
        }
        return instance;
    }
}

