/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.RedshiftDestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.CopyCommandJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RedshiftDestinationConfigurationJsonMarshaller {
    private static RedshiftDestinationConfigurationJsonMarshaller instance;

    public void marshall(RedshiftDestinationConfiguration redshiftDestinationConfiguration, JSONWriter jsonWriter) {
        if (redshiftDestinationConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (redshiftDestinationConfiguration.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value((Object)redshiftDestinationConfiguration.getRoleARN());
            }
            if (redshiftDestinationConfiguration.getClusterJDBCURL() != null) {
                jsonWriter.key("ClusterJDBCURL").value((Object)redshiftDestinationConfiguration.getClusterJDBCURL());
            }
            if (redshiftDestinationConfiguration.getCopyCommand() != null) {
                jsonWriter.key("CopyCommand");
                CopyCommandJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getCopyCommand(), jsonWriter);
            }
            if (redshiftDestinationConfiguration.getUsername() != null) {
                jsonWriter.key("Username").value((Object)redshiftDestinationConfiguration.getUsername());
            }
            if (redshiftDestinationConfiguration.getPassword() != null) {
                jsonWriter.key("Password").value((Object)redshiftDestinationConfiguration.getPassword());
            }
            if (redshiftDestinationConfiguration.getS3Configuration() != null) {
                jsonWriter.key("S3Configuration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getS3Configuration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

