/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDeliveryStreamRequestMarshaller
implements Marshaller<Request<CreateDeliveryStreamRequest>, CreateDeliveryStreamRequest> {
    public Request<CreateDeliveryStreamRequest> marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest) {
        if (createDeliveryStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeliveryStreamRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.CreateDeliveryStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDeliveryStreamRequest.getDeliveryStreamName() != null) {
                jsonWriter.key("DeliveryStreamName").value((Object)createDeliveryStreamRequest.getDeliveryStreamName());
            }
            if (createDeliveryStreamRequest.getS3DestinationConfiguration() != null) {
                jsonWriter.key("S3DestinationConfiguration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getS3DestinationConfiguration(), jsonWriter);
            }
            if (createDeliveryStreamRequest.getRedshiftDestinationConfiguration() != null) {
                jsonWriter.key("RedshiftDestinationConfiguration");
                RedshiftDestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getRedshiftDestinationConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

