/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafkaconnect.model.transform.VpcDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VpcDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> securityGroups;
    private List<String> subnets;

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public VpcDescription withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public VpcDescription withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public VpcDescription withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public VpcDescription withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcDescription)) {
            return false;
        }
        VpcDescription other = (VpcDescription)obj;
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || other.getSubnets().equals(this.getSubnets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        return hashCode;
    }

    public VpcDescription clone() {
        try {
            return (VpcDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

