/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivs.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListStreamSessionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * List of stream sessions.
     * </p>
     */
    private java.util.List<StreamSessionSummary> streamSessions;
    /**
     * <p>
     * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * List of stream sessions.
     * </p>
     * 
     * @return List of stream sessions.
     */

    public java.util.List<StreamSessionSummary> getStreamSessions() {
        return streamSessions;
    }

    /**
     * <p>
     * List of stream sessions.
     * </p>
     * 
     * @param streamSessions
     *        List of stream sessions.
     */

    public void setStreamSessions(java.util.Collection<StreamSessionSummary> streamSessions) {
        if (streamSessions == null) {
            this.streamSessions = null;
            return;
        }

        this.streamSessions = new java.util.ArrayList<StreamSessionSummary>(streamSessions);
    }

    /**
     * <p>
     * List of stream sessions.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStreamSessions(java.util.Collection)} or {@link #withStreamSessions(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param streamSessions
     *        List of stream sessions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamSessionsResult withStreamSessions(StreamSessionSummary... streamSessions) {
        if (this.streamSessions == null) {
            setStreamSessions(new java.util.ArrayList<StreamSessionSummary>(streamSessions.length));
        }
        for (StreamSessionSummary ele : streamSessions) {
            this.streamSessions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of stream sessions.
     * </p>
     * 
     * @param streamSessions
     *        List of stream sessions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamSessionsResult withStreamSessions(java.util.Collection<StreamSessionSummary> streamSessions) {
        setStreamSessions(streamSessions);
        return this;
    }

    /**
     * <p>
     * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     * 
     * @param nextToken
     *        If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *        the next set.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     * 
     * @return If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *         the next set.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     * 
     * @param nextToken
     *        If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *        the next set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamSessionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStreamSessions() != null)
            sb.append("StreamSessions: ").append(getStreamSessions()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListStreamSessionsResult == false)
            return false;
        ListStreamSessionsResult other = (ListStreamSessionsResult) obj;
        if (other.getStreamSessions() == null ^ this.getStreamSessions() == null)
            return false;
        if (other.getStreamSessions() != null && other.getStreamSessions().equals(this.getStreamSessions()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStreamSessions() == null) ? 0 : getStreamSessions().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListStreamSessionsResult clone() {
        try {
            return (ListStreamSessionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
