/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless;

import javax.annotation.Generated;

import com.amazonaws.services.iotwireless.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTWireless}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTWireless implements AWSIoTWireless {

    protected AbstractAWSIoTWireless() {
    }

    @Override
    public AssociateAwsAccountWithPartnerAccountResult associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMulticastGroupWithFuotaTaskResult associateMulticastGroupWithFuotaTask(AssociateMulticastGroupWithFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWirelessDeviceWithFuotaTaskResult associateWirelessDeviceWithFuotaTask(AssociateWirelessDeviceWithFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWirelessDeviceWithMulticastGroupResult associateWirelessDeviceWithMulticastGroup(AssociateWirelessDeviceWithMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWirelessDeviceWithThingResult associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWirelessGatewayWithCertificateResult associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWirelessGatewayWithThingResult associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMulticastGroupSessionResult cancelMulticastGroupSession(CancelMulticastGroupSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDestinationResult createDestination(CreateDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceProfileResult createDeviceProfile(CreateDeviceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFuotaTaskResult createFuotaTask(CreateFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMulticastGroupResult createMulticastGroup(CreateMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkAnalyzerConfigurationResult createNetworkAnalyzerConfiguration(CreateNetworkAnalyzerConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceProfileResult createServiceProfile(CreateServiceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWirelessDeviceResult createWirelessDevice(CreateWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWirelessGatewayResult createWirelessGateway(CreateWirelessGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWirelessGatewayTaskResult createWirelessGatewayTask(CreateWirelessGatewayTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWirelessGatewayTaskDefinitionResult createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDestinationResult deleteDestination(DeleteDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceProfileResult deleteDeviceProfile(DeleteDeviceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFuotaTaskResult deleteFuotaTask(DeleteFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMulticastGroupResult deleteMulticastGroup(DeleteMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkAnalyzerConfigurationResult deleteNetworkAnalyzerConfiguration(DeleteNetworkAnalyzerConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQueuedMessagesResult deleteQueuedMessages(DeleteQueuedMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceProfileResult deleteServiceProfile(DeleteServiceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWirelessDeviceResult deleteWirelessDevice(DeleteWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWirelessGatewayResult deleteWirelessGateway(DeleteWirelessGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWirelessGatewayTaskResult deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWirelessGatewayTaskDefinitionResult deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAwsAccountFromPartnerAccountResult disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMulticastGroupFromFuotaTaskResult disassociateMulticastGroupFromFuotaTask(DisassociateMulticastGroupFromFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWirelessDeviceFromFuotaTaskResult disassociateWirelessDeviceFromFuotaTask(DisassociateWirelessDeviceFromFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWirelessDeviceFromMulticastGroupResult disassociateWirelessDeviceFromMulticastGroup(
            DisassociateWirelessDeviceFromMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWirelessDeviceFromThingResult disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWirelessGatewayFromCertificateResult disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWirelessGatewayFromThingResult disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDestinationResult getDestination(GetDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceProfileResult getDeviceProfile(GetDeviceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventConfigurationByResourceTypesResult getEventConfigurationByResourceTypes(GetEventConfigurationByResourceTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFuotaTaskResult getFuotaTask(GetFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLogLevelsByResourceTypesResult getLogLevelsByResourceTypes(GetLogLevelsByResourceTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMulticastGroupResult getMulticastGroup(GetMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMulticastGroupSessionResult getMulticastGroupSession(GetMulticastGroupSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkAnalyzerConfigurationResult getNetworkAnalyzerConfiguration(GetNetworkAnalyzerConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPartnerAccountResult getPartnerAccount(GetPartnerAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GetPositionResult getPosition(GetPositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GetPositionConfigurationResult getPositionConfiguration(GetPositionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPositionEstimateResult getPositionEstimate(GetPositionEstimateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceEventConfigurationResult getResourceEventConfiguration(GetResourceEventConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceLogLevelResult getResourceLogLevel(GetResourceLogLevelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePositionResult getResourcePosition(GetResourcePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceEndpointResult getServiceEndpoint(GetServiceEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceProfileResult getServiceProfile(GetServiceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessDeviceResult getWirelessDevice(GetWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessDeviceStatisticsResult getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayResult getWirelessGateway(GetWirelessGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayCertificateResult getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayFirmwareInformationResult getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayStatisticsResult getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayTaskResult getWirelessGatewayTask(GetWirelessGatewayTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWirelessGatewayTaskDefinitionResult getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDestinationsResult listDestinations(ListDestinationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceProfilesResult listDeviceProfiles(ListDeviceProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventConfigurationsResult listEventConfigurations(ListEventConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFuotaTasksResult listFuotaTasks(ListFuotaTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMulticastGroupsResult listMulticastGroups(ListMulticastGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMulticastGroupsByFuotaTaskResult listMulticastGroupsByFuotaTask(ListMulticastGroupsByFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworkAnalyzerConfigurationsResult listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPartnerAccountsResult listPartnerAccounts(ListPartnerAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ListPositionConfigurationsResult listPositionConfigurations(ListPositionConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueuedMessagesResult listQueuedMessages(ListQueuedMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceProfilesResult listServiceProfiles(ListServiceProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWirelessDevicesResult listWirelessDevices(ListWirelessDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWirelessGatewayTaskDefinitionsResult listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWirelessGatewaysResult listWirelessGateways(ListWirelessGatewaysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public PutPositionConfigurationResult putPositionConfiguration(PutPositionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourceLogLevelResult putResourceLogLevel(PutResourceLogLevelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetAllResourceLogLevelsResult resetAllResourceLogLevels(ResetAllResourceLogLevelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetResourceLogLevelResult resetResourceLogLevel(ResetResourceLogLevelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendDataToMulticastGroupResult sendDataToMulticastGroup(SendDataToMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendDataToWirelessDeviceResult sendDataToWirelessDevice(SendDataToWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartBulkAssociateWirelessDeviceWithMulticastGroupResult startBulkAssociateWirelessDeviceWithMulticastGroup(
            StartBulkAssociateWirelessDeviceWithMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartBulkDisassociateWirelessDeviceFromMulticastGroupResult startBulkDisassociateWirelessDeviceFromMulticastGroup(
            StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartFuotaTaskResult startFuotaTask(StartFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMulticastGroupSessionResult startMulticastGroupSession(StartMulticastGroupSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestWirelessDeviceResult testWirelessDevice(TestWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDestinationResult updateDestination(UpdateDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEventConfigurationByResourceTypesResult updateEventConfigurationByResourceTypes(UpdateEventConfigurationByResourceTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFuotaTaskResult updateFuotaTask(UpdateFuotaTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLogLevelsByResourceTypesResult updateLogLevelsByResourceTypes(UpdateLogLevelsByResourceTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMulticastGroupResult updateMulticastGroup(UpdateMulticastGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkAnalyzerConfigurationResult updateNetworkAnalyzerConfiguration(UpdateNetworkAnalyzerConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePartnerAccountResult updatePartnerAccount(UpdatePartnerAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public UpdatePositionResult updatePosition(UpdatePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceEventConfigurationResult updateResourceEventConfiguration(UpdateResourceEventConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourcePositionResult updateResourcePosition(UpdateResourcePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWirelessDeviceResult updateWirelessDevice(UpdateWirelessDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWirelessGatewayResult updateWirelessGateway(UpdateWirelessGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
