/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.PropertyValue;
import java.util.Date;

@SdkInternalApi
public class PropertyValueMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").build();
    private static final MarshallingInfo<String> TIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("time").build();
    private static final PropertyValueMarshaller instance = new PropertyValueMarshaller();

    public static PropertyValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(PropertyValue propertyValue, ProtocolMarshaller protocolMarshaller) {
        if (propertyValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)propertyValue.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)propertyValue.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)propertyValue.getTime(), TIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

