/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSceneRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String workspaceId;
    private String sceneId;
    private String contentLocation;
    private String description;
    private List<String> capabilities;
    private Map<String, String> sceneMetadata;

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public UpdateSceneRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public String getSceneId() {
        return this.sceneId;
    }

    public UpdateSceneRequest withSceneId(String sceneId) {
        this.setSceneId(sceneId);
        return this;
    }

    public void setContentLocation(String contentLocation) {
        this.contentLocation = contentLocation;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public UpdateSceneRequest withContentLocation(String contentLocation) {
        this.setContentLocation(contentLocation);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateSceneRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public UpdateSceneRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public UpdateSceneRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public Map<String, String> getSceneMetadata() {
        return this.sceneMetadata;
    }

    public void setSceneMetadata(Map<String, String> sceneMetadata) {
        this.sceneMetadata = sceneMetadata;
    }

    public UpdateSceneRequest withSceneMetadata(Map<String, String> sceneMetadata) {
        this.setSceneMetadata(sceneMetadata);
        return this;
    }

    public UpdateSceneRequest addSceneMetadataEntry(String key, String value) {
        if (null == this.sceneMetadata) {
            this.sceneMetadata = new HashMap<String, String>();
        }
        if (this.sceneMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sceneMetadata.put(key, value);
        return this;
    }

    public UpdateSceneRequest clearSceneMetadataEntries() {
        this.sceneMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId()).append(",");
        }
        if (this.getSceneId() != null) {
            sb.append("SceneId: ").append(this.getSceneId()).append(",");
        }
        if (this.getContentLocation() != null) {
            sb.append("ContentLocation: ").append(this.getContentLocation()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getSceneMetadata() != null) {
            sb.append("SceneMetadata: ").append(this.getSceneMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSceneRequest)) {
            return false;
        }
        UpdateSceneRequest other = (UpdateSceneRequest)obj;
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        if (other.getWorkspaceId() != null && !other.getWorkspaceId().equals(this.getWorkspaceId())) {
            return false;
        }
        if (other.getSceneId() == null ^ this.getSceneId() == null) {
            return false;
        }
        if (other.getSceneId() != null && !other.getSceneId().equals(this.getSceneId())) {
            return false;
        }
        if (other.getContentLocation() == null ^ this.getContentLocation() == null) {
            return false;
        }
        if (other.getContentLocation() != null && !other.getContentLocation().equals(this.getContentLocation())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getSceneMetadata() == null ^ this.getSceneMetadata() == null) {
            return false;
        }
        return other.getSceneMetadata() == null || other.getSceneMetadata().equals(this.getSceneMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSceneId() == null ? 0 : this.getSceneId().hashCode());
        hashCode = 31 * hashCode + (this.getContentLocation() == null ? 0 : this.getContentLocation().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getSceneMetadata() == null ? 0 : this.getSceneMetadata().hashCode());
        return hashCode;
    }

    public UpdateSceneRequest clone() {
        return (UpdateSceneRequest)super.clone();
    }
}

