/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.iotsitewise.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeStorageConfigurationResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeStorageConfigurationResultJsonUnmarshaller implements Unmarshaller<DescribeStorageConfigurationResult, JsonUnmarshallerContext> {

    public DescribeStorageConfigurationResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeStorageConfigurationResult describeStorageConfigurationResult = new DescribeStorageConfigurationResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeStorageConfigurationResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("storageType", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setStorageType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("multiLayerStorage", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setMultiLayerStorage(MultiLayerStorageJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("disassociatedDataStorage", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setDisassociatedDataStorage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("retentionPeriod", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setRetentionPeriod(RetentionPeriodJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("configurationStatus", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setConfigurationStatus(ConfigurationStatusJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("lastUpdateDate", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setLastUpdateDate(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("warmTier", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setWarmTier(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("warmTierRetentionPeriod", targetDepth)) {
                    context.nextToken();
                    describeStorageConfigurationResult.setWarmTierRetentionPeriod(WarmTierRetentionPeriodJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeStorageConfigurationResult;
    }

    private static DescribeStorageConfigurationResultJsonUnmarshaller instance;

    public static DescribeStorageConfigurationResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeStorageConfigurationResultJsonUnmarshaller();
        return instance;
    }
}
