/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise;

import javax.annotation.Generated;

import com.amazonaws.services.iotsitewise.model.*;

/**
 * Abstract implementation of {@code AWSIoTSiteWiseAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTSiteWiseAsync extends AbstractAWSIoTSiteWise implements AWSIoTSiteWiseAsync {

    protected AbstractAWSIoTSiteWiseAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateAssetsResult> associateAssetsAsync(AssociateAssetsRequest request) {

        return associateAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateAssetsResult> associateAssetsAsync(AssociateAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateAssetsRequest, AssociateAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateTimeSeriesToAssetPropertyResult> associateTimeSeriesToAssetPropertyAsync(
            AssociateTimeSeriesToAssetPropertyRequest request) {

        return associateTimeSeriesToAssetPropertyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateTimeSeriesToAssetPropertyResult> associateTimeSeriesToAssetPropertyAsync(
            AssociateTimeSeriesToAssetPropertyRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateTimeSeriesToAssetPropertyRequest, AssociateTimeSeriesToAssetPropertyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchAssociateProjectAssetsResult> batchAssociateProjectAssetsAsync(BatchAssociateProjectAssetsRequest request) {

        return batchAssociateProjectAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchAssociateProjectAssetsResult> batchAssociateProjectAssetsAsync(BatchAssociateProjectAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchAssociateProjectAssetsRequest, BatchAssociateProjectAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchDisassociateProjectAssetsResult> batchDisassociateProjectAssetsAsync(BatchDisassociateProjectAssetsRequest request) {

        return batchDisassociateProjectAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchDisassociateProjectAssetsResult> batchDisassociateProjectAssetsAsync(BatchDisassociateProjectAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchDisassociateProjectAssetsRequest, BatchDisassociateProjectAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchPutAssetPropertyValueResult> batchPutAssetPropertyValueAsync(BatchPutAssetPropertyValueRequest request) {

        return batchPutAssetPropertyValueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchPutAssetPropertyValueResult> batchPutAssetPropertyValueAsync(BatchPutAssetPropertyValueRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchPutAssetPropertyValueRequest, BatchPutAssetPropertyValueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request) {

        return createAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAccessPolicyRequest, CreateAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request) {

        return createAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssetRequest, CreateAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssetModelResult> createAssetModelAsync(CreateAssetModelRequest request) {

        return createAssetModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssetModelResult> createAssetModelAsync(CreateAssetModelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssetModelRequest, CreateAssetModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDashboardResult> createDashboardAsync(CreateDashboardRequest request) {

        return createDashboardAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDashboardResult> createDashboardAsync(CreateDashboardRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDashboardRequest, CreateDashboardResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request) {

        return createGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGatewayRequest, CreateGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePortalResult> createPortalAsync(CreatePortalRequest request) {

        return createPortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePortalResult> createPortalAsync(CreatePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePortalRequest, CreatePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {

        return createProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request) {

        return deleteAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAccessPolicyRequest, DeleteAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request) {

        return deleteAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssetRequest, DeleteAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetModelResult> deleteAssetModelAsync(DeleteAssetModelRequest request) {

        return deleteAssetModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetModelResult> deleteAssetModelAsync(DeleteAssetModelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssetModelRequest, DeleteAssetModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDashboardResult> deleteDashboardAsync(DeleteDashboardRequest request) {

        return deleteDashboardAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDashboardResult> deleteDashboardAsync(DeleteDashboardRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDashboardRequest, DeleteDashboardResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request) {

        return deleteGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGatewayRequest, DeleteGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePortalResult> deletePortalAsync(DeletePortalRequest request) {

        return deletePortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePortalResult> deletePortalAsync(DeletePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePortalRequest, DeletePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {

        return deleteProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTimeSeriesResult> deleteTimeSeriesAsync(DeleteTimeSeriesRequest request) {

        return deleteTimeSeriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTimeSeriesResult> deleteTimeSeriesAsync(DeleteTimeSeriesRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTimeSeriesRequest, DeleteTimeSeriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAccessPolicyResult> describeAccessPolicyAsync(DescribeAccessPolicyRequest request) {

        return describeAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAccessPolicyResult> describeAccessPolicyAsync(DescribeAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAccessPolicyRequest, DescribeAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetResult> describeAssetAsync(DescribeAssetRequest request) {

        return describeAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetResult> describeAssetAsync(DescribeAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAssetRequest, DescribeAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetModelResult> describeAssetModelAsync(DescribeAssetModelRequest request) {

        return describeAssetModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetModelResult> describeAssetModelAsync(DescribeAssetModelRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAssetModelRequest, DescribeAssetModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetPropertyResult> describeAssetPropertyAsync(DescribeAssetPropertyRequest request) {

        return describeAssetPropertyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAssetPropertyResult> describeAssetPropertyAsync(DescribeAssetPropertyRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAssetPropertyRequest, DescribeAssetPropertyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeDashboardResult> describeDashboardAsync(DescribeDashboardRequest request) {

        return describeDashboardAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeDashboardResult> describeDashboardAsync(DescribeDashboardRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeDashboardRequest, DescribeDashboardResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeDefaultEncryptionConfigurationResult> describeDefaultEncryptionConfigurationAsync(
            DescribeDefaultEncryptionConfigurationRequest request) {

        return describeDefaultEncryptionConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeDefaultEncryptionConfigurationResult> describeDefaultEncryptionConfigurationAsync(
            DescribeDefaultEncryptionConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeDefaultEncryptionConfigurationRequest, DescribeDefaultEncryptionConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeGatewayResult> describeGatewayAsync(DescribeGatewayRequest request) {

        return describeGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeGatewayResult> describeGatewayAsync(DescribeGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeGatewayRequest, DescribeGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeGatewayCapabilityConfigurationResult> describeGatewayCapabilityConfigurationAsync(
            DescribeGatewayCapabilityConfigurationRequest request) {

        return describeGatewayCapabilityConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeGatewayCapabilityConfigurationResult> describeGatewayCapabilityConfigurationAsync(
            DescribeGatewayCapabilityConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeGatewayCapabilityConfigurationRequest, DescribeGatewayCapabilityConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request) {

        return describeLoggingOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePortalResult> describePortalAsync(DescribePortalRequest request) {

        return describePortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePortalResult> describePortalAsync(DescribePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePortalRequest, DescribePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request) {

        return describeProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeProjectRequest, DescribeProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeStorageConfigurationResult> describeStorageConfigurationAsync(DescribeStorageConfigurationRequest request) {

        return describeStorageConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeStorageConfigurationResult> describeStorageConfigurationAsync(DescribeStorageConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeStorageConfigurationRequest, DescribeStorageConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeTimeSeriesResult> describeTimeSeriesAsync(DescribeTimeSeriesRequest request) {

        return describeTimeSeriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeTimeSeriesResult> describeTimeSeriesAsync(DescribeTimeSeriesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeTimeSeriesRequest, DescribeTimeSeriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateAssetsResult> disassociateAssetsAsync(DisassociateAssetsRequest request) {

        return disassociateAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateAssetsResult> disassociateAssetsAsync(DisassociateAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateAssetsRequest, DisassociateAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateTimeSeriesFromAssetPropertyResult> disassociateTimeSeriesFromAssetPropertyAsync(
            DisassociateTimeSeriesFromAssetPropertyRequest request) {

        return disassociateTimeSeriesFromAssetPropertyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateTimeSeriesFromAssetPropertyResult> disassociateTimeSeriesFromAssetPropertyAsync(
            DisassociateTimeSeriesFromAssetPropertyRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateTimeSeriesFromAssetPropertyRequest, DisassociateTimeSeriesFromAssetPropertyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyAggregatesResult> getAssetPropertyAggregatesAsync(GetAssetPropertyAggregatesRequest request) {

        return getAssetPropertyAggregatesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyAggregatesResult> getAssetPropertyAggregatesAsync(GetAssetPropertyAggregatesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssetPropertyAggregatesRequest, GetAssetPropertyAggregatesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyValueResult> getAssetPropertyValueAsync(GetAssetPropertyValueRequest request) {

        return getAssetPropertyValueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyValueResult> getAssetPropertyValueAsync(GetAssetPropertyValueRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssetPropertyValueRequest, GetAssetPropertyValueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyValueHistoryResult> getAssetPropertyValueHistoryAsync(GetAssetPropertyValueHistoryRequest request) {

        return getAssetPropertyValueHistoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssetPropertyValueHistoryResult> getAssetPropertyValueHistoryAsync(GetAssetPropertyValueHistoryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssetPropertyValueHistoryRequest, GetAssetPropertyValueHistoryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetInterpolatedAssetPropertyValuesResult> getInterpolatedAssetPropertyValuesAsync(
            GetInterpolatedAssetPropertyValuesRequest request) {

        return getInterpolatedAssetPropertyValuesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetInterpolatedAssetPropertyValuesResult> getInterpolatedAssetPropertyValuesAsync(
            GetInterpolatedAssetPropertyValuesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetInterpolatedAssetPropertyValuesRequest, GetInterpolatedAssetPropertyValuesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request) {

        return listAccessPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAccessPoliciesRequest, ListAccessPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssetModelsResult> listAssetModelsAsync(ListAssetModelsRequest request) {

        return listAssetModelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssetModelsResult> listAssetModelsAsync(ListAssetModelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssetModelsRequest, ListAssetModelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssetRelationshipsResult> listAssetRelationshipsAsync(ListAssetRelationshipsRequest request) {

        return listAssetRelationshipsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssetRelationshipsResult> listAssetRelationshipsAsync(ListAssetRelationshipsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssetRelationshipsRequest, ListAssetRelationshipsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request) {

        return listAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssetsRequest, ListAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedAssetsResult> listAssociatedAssetsAsync(ListAssociatedAssetsRequest request) {

        return listAssociatedAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedAssetsResult> listAssociatedAssetsAsync(ListAssociatedAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssociatedAssetsRequest, ListAssociatedAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request) {

        return listDashboardsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDashboardsRequest, ListDashboardsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request) {

        return listGatewaysAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGatewaysRequest, ListGatewaysResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPortalsResult> listPortalsAsync(ListPortalsRequest request) {

        return listPortalsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPortalsResult> listPortalsAsync(ListPortalsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPortalsRequest, ListPortalsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectAssetsResult> listProjectAssetsAsync(ListProjectAssetsRequest request) {

        return listProjectAssetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectAssetsResult> listProjectAssetsAsync(ListProjectAssetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectAssetsRequest, ListProjectAssetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {

        return listProjectsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTimeSeriesResult> listTimeSeriesAsync(ListTimeSeriesRequest request) {

        return listTimeSeriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTimeSeriesResult> listTimeSeriesAsync(ListTimeSeriesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTimeSeriesRequest, ListTimeSeriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutDefaultEncryptionConfigurationResult> putDefaultEncryptionConfigurationAsync(
            PutDefaultEncryptionConfigurationRequest request) {

        return putDefaultEncryptionConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutDefaultEncryptionConfigurationResult> putDefaultEncryptionConfigurationAsync(
            PutDefaultEncryptionConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<PutDefaultEncryptionConfigurationRequest, PutDefaultEncryptionConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request) {

        return putLoggingOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<PutLoggingOptionsRequest, PutLoggingOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutStorageConfigurationResult> putStorageConfigurationAsync(PutStorageConfigurationRequest request) {

        return putStorageConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutStorageConfigurationResult> putStorageConfigurationAsync(PutStorageConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<PutStorageConfigurationRequest, PutStorageConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request) {

        return updateAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAccessPolicyRequest, UpdateAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetResult> updateAssetAsync(UpdateAssetRequest request) {

        return updateAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetResult> updateAssetAsync(UpdateAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAssetRequest, UpdateAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetModelResult> updateAssetModelAsync(UpdateAssetModelRequest request) {

        return updateAssetModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetModelResult> updateAssetModelAsync(UpdateAssetModelRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAssetModelRequest, UpdateAssetModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetPropertyResult> updateAssetPropertyAsync(UpdateAssetPropertyRequest request) {

        return updateAssetPropertyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAssetPropertyResult> updateAssetPropertyAsync(UpdateAssetPropertyRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAssetPropertyRequest, UpdateAssetPropertyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDashboardResult> updateDashboardAsync(UpdateDashboardRequest request) {

        return updateDashboardAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDashboardResult> updateDashboardAsync(UpdateDashboardRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDashboardRequest, UpdateDashboardResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGatewayResult> updateGatewayAsync(UpdateGatewayRequest request) {

        return updateGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGatewayResult> updateGatewayAsync(UpdateGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGatewayRequest, UpdateGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGatewayCapabilityConfigurationResult> updateGatewayCapabilityConfigurationAsync(
            UpdateGatewayCapabilityConfigurationRequest request) {

        return updateGatewayCapabilityConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGatewayCapabilityConfigurationResult> updateGatewayCapabilityConfigurationAsync(
            UpdateGatewayCapabilityConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGatewayCapabilityConfigurationRequest, UpdateGatewayCapabilityConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePortalResult> updatePortalAsync(UpdatePortalRequest request) {

        return updatePortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePortalResult> updatePortalAsync(UpdatePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePortalRequest, UpdatePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {

        return updateProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
