/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsData;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataClientBuilder;
import com.amazonaws.services.ioteventsdata.model.AWSIoTEventsDataException;
import com.amazonaws.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchAcknowledgeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchDisableAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchDisableAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchEnableAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchEnableAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageRequest;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageResult;
import com.amazonaws.services.ioteventsdata.model.BatchResetAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchResetAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchSnoozeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchSnoozeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorResult;
import com.amazonaws.services.ioteventsdata.model.DescribeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.DescribeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorResult;
import com.amazonaws.services.ioteventsdata.model.ListAlarmsRequest;
import com.amazonaws.services.ioteventsdata.model.ListAlarmsResult;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsRequest;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsResult;
import com.amazonaws.services.ioteventsdata.model.transform.BatchAcknowledgeAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchAcknowledgeAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchDisableAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchDisableAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchEnableAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchEnableAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchPutMessageRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchPutMessageResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchResetAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchResetAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchSnoozeAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchSnoozeAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchUpdateDetectorRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.BatchUpdateDetectorResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.DescribeAlarmRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.DescribeAlarmResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.DescribeDetectorRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.DescribeDetectorResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ListAlarmsRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ListAlarmsResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ListDetectorsRequestProtocolMarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ListDetectorsResultJsonUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.ioteventsdata.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTEventsDataClient
extends AmazonWebServiceClient
implements AWSIoTEventsData {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTEventsData.class);
    private static final String DEFAULT_SIGNING_NAME = "ioteventsdata";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIoTEventsDataException.class));

    public static AWSIoTEventsDataClientBuilder builder() {
        return AWSIoTEventsDataClientBuilder.standard();
    }

    AWSIoTEventsDataClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTEventsDataClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("data.iotevents");
        this.setEndpoint("data.iotevents.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ioteventsdata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ioteventsdata/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchAcknowledgeAlarmResult batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest request) {
        request = (BatchAcknowledgeAlarmRequest)this.beforeClientExecution(request);
        return this.executeBatchAcknowledgeAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchAcknowledgeAlarmResult executeBatchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest batchAcknowledgeAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchAcknowledgeAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchAcknowledgeAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchAcknowledgeAlarmRequestProtocolMarshaller(protocolFactory).marshall((BatchAcknowledgeAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchAcknowledgeAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchAcknowledgeAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchAcknowledgeAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchAcknowledgeAlarmResult batchAcknowledgeAlarmResult = (BatchAcknowledgeAlarmResult)response.getAwsResponse();
            return batchAcknowledgeAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDisableAlarmResult batchDisableAlarm(BatchDisableAlarmRequest request) {
        request = (BatchDisableAlarmRequest)this.beforeClientExecution(request);
        return this.executeBatchDisableAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDisableAlarmResult executeBatchDisableAlarm(BatchDisableAlarmRequest batchDisableAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDisableAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDisableAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDisableAlarmRequestProtocolMarshaller(protocolFactory).marshall((BatchDisableAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDisableAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDisableAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDisableAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDisableAlarmResult batchDisableAlarmResult = (BatchDisableAlarmResult)response.getAwsResponse();
            return batchDisableAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchEnableAlarmResult batchEnableAlarm(BatchEnableAlarmRequest request) {
        request = (BatchEnableAlarmRequest)this.beforeClientExecution(request);
        return this.executeBatchEnableAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchEnableAlarmResult executeBatchEnableAlarm(BatchEnableAlarmRequest batchEnableAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchEnableAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchEnableAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchEnableAlarmRequestProtocolMarshaller(protocolFactory).marshall((BatchEnableAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchEnableAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchEnableAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchEnableAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchEnableAlarmResult batchEnableAlarmResult = (BatchEnableAlarmResult)response.getAwsResponse();
            return batchEnableAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchPutMessageResult batchPutMessage(BatchPutMessageRequest request) {
        request = (BatchPutMessageRequest)this.beforeClientExecution(request);
        return this.executeBatchPutMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutMessageResult executeBatchPutMessage(BatchPutMessageRequest batchPutMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutMessageRequestProtocolMarshaller(protocolFactory).marshall((BatchPutMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchPutMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchPutMessage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchPutMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchPutMessageResult batchPutMessageResult = (BatchPutMessageResult)response.getAwsResponse();
            return batchPutMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchResetAlarmResult batchResetAlarm(BatchResetAlarmRequest request) {
        request = (BatchResetAlarmRequest)this.beforeClientExecution(request);
        return this.executeBatchResetAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchResetAlarmResult executeBatchResetAlarm(BatchResetAlarmRequest batchResetAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchResetAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchResetAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchResetAlarmRequestProtocolMarshaller(protocolFactory).marshall((BatchResetAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchResetAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchResetAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchResetAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchResetAlarmResult batchResetAlarmResult = (BatchResetAlarmResult)response.getAwsResponse();
            return batchResetAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchSnoozeAlarmResult batchSnoozeAlarm(BatchSnoozeAlarmRequest request) {
        request = (BatchSnoozeAlarmRequest)this.beforeClientExecution(request);
        return this.executeBatchSnoozeAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchSnoozeAlarmResult executeBatchSnoozeAlarm(BatchSnoozeAlarmRequest batchSnoozeAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchSnoozeAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchSnoozeAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchSnoozeAlarmRequestProtocolMarshaller(protocolFactory).marshall((BatchSnoozeAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchSnoozeAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchSnoozeAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchSnoozeAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchSnoozeAlarmResult batchSnoozeAlarmResult = (BatchSnoozeAlarmResult)response.getAwsResponse();
            return batchSnoozeAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUpdateDetectorResult batchUpdateDetector(BatchUpdateDetectorRequest request) {
        request = (BatchUpdateDetectorRequest)this.beforeClientExecution(request);
        return this.executeBatchUpdateDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateDetectorResult executeBatchUpdateDetector(BatchUpdateDetectorRequest batchUpdateDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateDetectorRequestProtocolMarshaller(protocolFactory).marshall((BatchUpdateDetectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUpdateDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUpdateDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUpdateDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpdateDetectorResult batchUpdateDetectorResult = (BatchUpdateDetectorResult)response.getAwsResponse();
            return batchUpdateDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAlarmResult describeAlarm(DescribeAlarmRequest request) {
        request = (DescribeAlarmRequest)this.beforeClientExecution(request);
        return this.executeDescribeAlarm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAlarmResult executeDescribeAlarm(DescribeAlarmRequest describeAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAlarmRequestProtocolMarshaller(protocolFactory).marshall((DescribeAlarmRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAlarmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAlarm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAlarmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAlarmResult describeAlarmResult = (DescribeAlarmResult)response.getAwsResponse();
            return describeAlarmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDetectorResult describeDetector(DescribeDetectorRequest request) {
        request = (DescribeDetectorRequest)this.beforeClientExecution(request);
        return this.executeDescribeDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDetectorResult executeDescribeDetector(DescribeDetectorRequest describeDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDetectorRequestProtocolMarshaller(protocolFactory).marshall((DescribeDetectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDetectorResult describeDetectorResult = (DescribeDetectorResult)response.getAwsResponse();
            return describeDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAlarmsResult listAlarms(ListAlarmsRequest request) {
        request = (ListAlarmsRequest)this.beforeClientExecution(request);
        return this.executeListAlarms(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAlarmsResult executeListAlarms(ListAlarmsRequest listAlarmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAlarmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAlarmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAlarmsRequestProtocolMarshaller(protocolFactory).marshall((ListAlarmsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAlarmsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAlarms");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAlarmsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAlarmsResult listAlarmsResult = (ListAlarmsResult)response.getAwsResponse();
            return listAlarmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDetectorsResult listDetectors(ListDetectorsRequest request) {
        request = (ListDetectorsRequest)this.beforeClientExecution(request);
        return this.executeListDetectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDetectorsResult executeListDetectors(ListDetectorsRequest listDetectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDetectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDetectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDetectorsRequestProtocolMarshaller(protocolFactory).marshall((ListDetectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDetectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDetectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDetectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDetectorsResult listDetectorsResult = (ListDetectorsResult)response.getAwsResponse();
            return listDetectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

