/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotdeviceadvisor.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.iotdeviceadvisor.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * SuiteDefinitionInformationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class SuiteDefinitionInformationMarshaller {

    private static final MarshallingInfo<String> SUITEDEFINITIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suiteDefinitionId").build();
    private static final MarshallingInfo<String> SUITEDEFINITIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suiteDefinitionName").build();
    private static final MarshallingInfo<List> DEFAULTDEVICES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultDevices").build();
    private static final MarshallingInfo<Boolean> INTENDEDFORQUALIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intendedForQualification").build();
    private static final MarshallingInfo<Boolean> ISLONGDURATIONTEST_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isLongDurationTest").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("protocol").build();
    private static final MarshallingInfo<java.util.Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();

    private static final SuiteDefinitionInformationMarshaller instance = new SuiteDefinitionInformationMarshaller();

    public static SuiteDefinitionInformationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(SuiteDefinitionInformation suiteDefinitionInformation, ProtocolMarshaller protocolMarshaller) {

        if (suiteDefinitionInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(suiteDefinitionInformation.getSuiteDefinitionId(), SUITEDEFINITIONID_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getSuiteDefinitionName(), SUITEDEFINITIONNAME_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getDefaultDevices(), DEFAULTDEVICES_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getIntendedForQualification(), INTENDEDFORQUALIFICATION_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getIsLongDurationTest(), ISLONGDURATIONTEST_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(suiteDefinitionInformation.getCreatedAt(), CREATEDAT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
