/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.DeviceUnderTest;
import com.amazonaws.services.iotdeviceadvisor.model.Protocol;
import com.amazonaws.services.iotdeviceadvisor.model.transform.SuiteDefinitionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SuiteDefinitionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String suiteDefinitionName;
    private List<DeviceUnderTest> devices;
    private Boolean intendedForQualification;
    private Boolean isLongDurationTest;
    private String rootGroup;
    private String devicePermissionRoleArn;
    private String protocol;

    public void setSuiteDefinitionName(String suiteDefinitionName) {
        this.suiteDefinitionName = suiteDefinitionName;
    }

    public String getSuiteDefinitionName() {
        return this.suiteDefinitionName;
    }

    public SuiteDefinitionConfiguration withSuiteDefinitionName(String suiteDefinitionName) {
        this.setSuiteDefinitionName(suiteDefinitionName);
        return this;
    }

    public List<DeviceUnderTest> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<DeviceUnderTest> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<DeviceUnderTest>(devices);
    }

    public SuiteDefinitionConfiguration withDevices(DeviceUnderTest ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<DeviceUnderTest>(devices.length));
        }
        for (DeviceUnderTest ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public SuiteDefinitionConfiguration withDevices(Collection<DeviceUnderTest> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setIntendedForQualification(Boolean intendedForQualification) {
        this.intendedForQualification = intendedForQualification;
    }

    public Boolean getIntendedForQualification() {
        return this.intendedForQualification;
    }

    public SuiteDefinitionConfiguration withIntendedForQualification(Boolean intendedForQualification) {
        this.setIntendedForQualification(intendedForQualification);
        return this;
    }

    public Boolean isIntendedForQualification() {
        return this.intendedForQualification;
    }

    public void setIsLongDurationTest(Boolean isLongDurationTest) {
        this.isLongDurationTest = isLongDurationTest;
    }

    public Boolean getIsLongDurationTest() {
        return this.isLongDurationTest;
    }

    public SuiteDefinitionConfiguration withIsLongDurationTest(Boolean isLongDurationTest) {
        this.setIsLongDurationTest(isLongDurationTest);
        return this;
    }

    public Boolean isLongDurationTest() {
        return this.isLongDurationTest;
    }

    public void setRootGroup(String rootGroup) {
        this.rootGroup = rootGroup;
    }

    public String getRootGroup() {
        return this.rootGroup;
    }

    public SuiteDefinitionConfiguration withRootGroup(String rootGroup) {
        this.setRootGroup(rootGroup);
        return this;
    }

    public void setDevicePermissionRoleArn(String devicePermissionRoleArn) {
        this.devicePermissionRoleArn = devicePermissionRoleArn;
    }

    public String getDevicePermissionRoleArn() {
        return this.devicePermissionRoleArn;
    }

    public SuiteDefinitionConfiguration withDevicePermissionRoleArn(String devicePermissionRoleArn) {
        this.setDevicePermissionRoleArn(devicePermissionRoleArn);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SuiteDefinitionConfiguration withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public SuiteDefinitionConfiguration withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuiteDefinitionName() != null) {
            sb.append("SuiteDefinitionName: ").append(this.getSuiteDefinitionName()).append(",");
        }
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getIntendedForQualification() != null) {
            sb.append("IntendedForQualification: ").append(this.getIntendedForQualification()).append(",");
        }
        if (this.getIsLongDurationTest() != null) {
            sb.append("IsLongDurationTest: ").append(this.getIsLongDurationTest()).append(",");
        }
        if (this.getRootGroup() != null) {
            sb.append("RootGroup: ").append(this.getRootGroup()).append(",");
        }
        if (this.getDevicePermissionRoleArn() != null) {
            sb.append("DevicePermissionRoleArn: ").append(this.getDevicePermissionRoleArn()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionConfiguration)) {
            return false;
        }
        SuiteDefinitionConfiguration other = (SuiteDefinitionConfiguration)obj;
        if (other.getSuiteDefinitionName() == null ^ this.getSuiteDefinitionName() == null) {
            return false;
        }
        if (other.getSuiteDefinitionName() != null && !other.getSuiteDefinitionName().equals(this.getSuiteDefinitionName())) {
            return false;
        }
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getIntendedForQualification() == null ^ this.getIntendedForQualification() == null) {
            return false;
        }
        if (other.getIntendedForQualification() != null && !other.getIntendedForQualification().equals(this.getIntendedForQualification())) {
            return false;
        }
        if (other.getIsLongDurationTest() == null ^ this.getIsLongDurationTest() == null) {
            return false;
        }
        if (other.getIsLongDurationTest() != null && !other.getIsLongDurationTest().equals(this.getIsLongDurationTest())) {
            return false;
        }
        if (other.getRootGroup() == null ^ this.getRootGroup() == null) {
            return false;
        }
        if (other.getRootGroup() != null && !other.getRootGroup().equals(this.getRootGroup())) {
            return false;
        }
        if (other.getDevicePermissionRoleArn() == null ^ this.getDevicePermissionRoleArn() == null) {
            return false;
        }
        if (other.getDevicePermissionRoleArn() != null && !other.getDevicePermissionRoleArn().equals(this.getDevicePermissionRoleArn())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuiteDefinitionName() == null ? 0 : this.getSuiteDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getIntendedForQualification() == null ? 0 : this.getIntendedForQualification().hashCode());
        hashCode = 31 * hashCode + (this.getIsLongDurationTest() == null ? 0 : this.getIsLongDurationTest().hashCode());
        hashCode = 31 * hashCode + (this.getRootGroup() == null ? 0 : this.getRootGroup().hashCode());
        hashCode = 31 * hashCode + (this.getDevicePermissionRoleArn() == null ? 0 : this.getDevicePermissionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public SuiteDefinitionConfiguration clone() {
        try {
            return (SuiteDefinitionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuiteDefinitionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

