/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotdeviceadvisor.AWSIoTDeviceAdvisorAsync;
import com.amazonaws.services.iotdeviceadvisor.AWSIoTDeviceAdvisorAsyncClientBuilder;
import com.amazonaws.services.iotdeviceadvisor.AWSIoTDeviceAdvisorClient;
import com.amazonaws.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.CreateSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetEndpointRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetEndpointResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunReportRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunReportResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteDefinitionsResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteRunsResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListTagsForResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.StartSuiteRunRequest;
import com.amazonaws.services.iotdeviceadvisor.model.StartSuiteRunResult;
import com.amazonaws.services.iotdeviceadvisor.model.StopSuiteRunRequest;
import com.amazonaws.services.iotdeviceadvisor.model.StopSuiteRunResult;
import com.amazonaws.services.iotdeviceadvisor.model.TagResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.TagResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.UntagResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.UntagResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTDeviceAdvisorAsyncClient
extends AWSIoTDeviceAdvisorClient
implements AWSIoTDeviceAdvisorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTDeviceAdvisorAsyncClientBuilder asyncBuilder() {
        return AWSIoTDeviceAdvisorAsyncClientBuilder.standard();
    }

    AWSIoTDeviceAdvisorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTDeviceAdvisorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSuiteDefinitionResult> createSuiteDefinitionAsync(CreateSuiteDefinitionRequest request) {
        return this.createSuiteDefinitionAsync(request, null);
    }

    @Override
    public Future<CreateSuiteDefinitionResult> createSuiteDefinitionAsync(CreateSuiteDefinitionRequest request, final AsyncHandler<CreateSuiteDefinitionRequest, CreateSuiteDefinitionResult> asyncHandler) {
        final CreateSuiteDefinitionRequest finalRequest = (CreateSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSuiteDefinitionResult>(){

            @Override
            public CreateSuiteDefinitionResult call() throws Exception {
                CreateSuiteDefinitionResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeCreateSuiteDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSuiteDefinitionResult> deleteSuiteDefinitionAsync(DeleteSuiteDefinitionRequest request) {
        return this.deleteSuiteDefinitionAsync(request, null);
    }

    @Override
    public Future<DeleteSuiteDefinitionResult> deleteSuiteDefinitionAsync(DeleteSuiteDefinitionRequest request, final AsyncHandler<DeleteSuiteDefinitionRequest, DeleteSuiteDefinitionResult> asyncHandler) {
        final DeleteSuiteDefinitionRequest finalRequest = (DeleteSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSuiteDefinitionResult>(){

            @Override
            public DeleteSuiteDefinitionResult call() throws Exception {
                DeleteSuiteDefinitionResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeDeleteSuiteDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEndpointResult> getEndpointAsync(GetEndpointRequest request) {
        return this.getEndpointAsync(request, null);
    }

    @Override
    public Future<GetEndpointResult> getEndpointAsync(GetEndpointRequest request, final AsyncHandler<GetEndpointRequest, GetEndpointResult> asyncHandler) {
        final GetEndpointRequest finalRequest = (GetEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEndpointResult>(){

            @Override
            public GetEndpointResult call() throws Exception {
                GetEndpointResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeGetEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSuiteDefinitionResult> getSuiteDefinitionAsync(GetSuiteDefinitionRequest request) {
        return this.getSuiteDefinitionAsync(request, null);
    }

    @Override
    public Future<GetSuiteDefinitionResult> getSuiteDefinitionAsync(GetSuiteDefinitionRequest request, final AsyncHandler<GetSuiteDefinitionRequest, GetSuiteDefinitionResult> asyncHandler) {
        final GetSuiteDefinitionRequest finalRequest = (GetSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSuiteDefinitionResult>(){

            @Override
            public GetSuiteDefinitionResult call() throws Exception {
                GetSuiteDefinitionResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeGetSuiteDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSuiteRunResult> getSuiteRunAsync(GetSuiteRunRequest request) {
        return this.getSuiteRunAsync(request, null);
    }

    @Override
    public Future<GetSuiteRunResult> getSuiteRunAsync(GetSuiteRunRequest request, final AsyncHandler<GetSuiteRunRequest, GetSuiteRunResult> asyncHandler) {
        final GetSuiteRunRequest finalRequest = (GetSuiteRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSuiteRunResult>(){

            @Override
            public GetSuiteRunResult call() throws Exception {
                GetSuiteRunResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeGetSuiteRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSuiteRunReportResult> getSuiteRunReportAsync(GetSuiteRunReportRequest request) {
        return this.getSuiteRunReportAsync(request, null);
    }

    @Override
    public Future<GetSuiteRunReportResult> getSuiteRunReportAsync(GetSuiteRunReportRequest request, final AsyncHandler<GetSuiteRunReportRequest, GetSuiteRunReportResult> asyncHandler) {
        final GetSuiteRunReportRequest finalRequest = (GetSuiteRunReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSuiteRunReportResult>(){

            @Override
            public GetSuiteRunReportResult call() throws Exception {
                GetSuiteRunReportResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeGetSuiteRunReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSuiteDefinitionsResult> listSuiteDefinitionsAsync(ListSuiteDefinitionsRequest request) {
        return this.listSuiteDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListSuiteDefinitionsResult> listSuiteDefinitionsAsync(ListSuiteDefinitionsRequest request, final AsyncHandler<ListSuiteDefinitionsRequest, ListSuiteDefinitionsResult> asyncHandler) {
        final ListSuiteDefinitionsRequest finalRequest = (ListSuiteDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSuiteDefinitionsResult>(){

            @Override
            public ListSuiteDefinitionsResult call() throws Exception {
                ListSuiteDefinitionsResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeListSuiteDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSuiteRunsResult> listSuiteRunsAsync(ListSuiteRunsRequest request) {
        return this.listSuiteRunsAsync(request, null);
    }

    @Override
    public Future<ListSuiteRunsResult> listSuiteRunsAsync(ListSuiteRunsRequest request, final AsyncHandler<ListSuiteRunsRequest, ListSuiteRunsResult> asyncHandler) {
        final ListSuiteRunsRequest finalRequest = (ListSuiteRunsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSuiteRunsResult>(){

            @Override
            public ListSuiteRunsResult call() throws Exception {
                ListSuiteRunsResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeListSuiteRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSuiteRunResult> startSuiteRunAsync(StartSuiteRunRequest request) {
        return this.startSuiteRunAsync(request, null);
    }

    @Override
    public Future<StartSuiteRunResult> startSuiteRunAsync(StartSuiteRunRequest request, final AsyncHandler<StartSuiteRunRequest, StartSuiteRunResult> asyncHandler) {
        final StartSuiteRunRequest finalRequest = (StartSuiteRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSuiteRunResult>(){

            @Override
            public StartSuiteRunResult call() throws Exception {
                StartSuiteRunResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeStartSuiteRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopSuiteRunResult> stopSuiteRunAsync(StopSuiteRunRequest request) {
        return this.stopSuiteRunAsync(request, null);
    }

    @Override
    public Future<StopSuiteRunResult> stopSuiteRunAsync(StopSuiteRunRequest request, final AsyncHandler<StopSuiteRunRequest, StopSuiteRunResult> asyncHandler) {
        final StopSuiteRunRequest finalRequest = (StopSuiteRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopSuiteRunResult>(){

            @Override
            public StopSuiteRunResult call() throws Exception {
                StopSuiteRunResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeStopSuiteRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSuiteDefinitionResult> updateSuiteDefinitionAsync(UpdateSuiteDefinitionRequest request) {
        return this.updateSuiteDefinitionAsync(request, null);
    }

    @Override
    public Future<UpdateSuiteDefinitionResult> updateSuiteDefinitionAsync(UpdateSuiteDefinitionRequest request, final AsyncHandler<UpdateSuiteDefinitionRequest, UpdateSuiteDefinitionResult> asyncHandler) {
        final UpdateSuiteDefinitionRequest finalRequest = (UpdateSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSuiteDefinitionResult>(){

            @Override
            public UpdateSuiteDefinitionResult call() throws Exception {
                UpdateSuiteDefinitionResult result = null;
                try {
                    result = AWSIoTDeviceAdvisorAsyncClient.this.executeUpdateSuiteDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

