/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.DatastorePartitions;
import com.amazonaws.services.iotanalytics.model.DatastoreStorage;
import com.amazonaws.services.iotanalytics.model.FileFormatConfiguration;
import com.amazonaws.services.iotanalytics.model.RetentionPeriod;
import com.amazonaws.services.iotanalytics.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDatastoreRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String datastoreName;
    private DatastoreStorage datastoreStorage;
    private RetentionPeriod retentionPeriod;
    private List<Tag> tags;
    private FileFormatConfiguration fileFormatConfiguration;
    private DatastorePartitions datastorePartitions;

    public void setDatastoreName(String datastoreName) {
        this.datastoreName = datastoreName;
    }

    public String getDatastoreName() {
        return this.datastoreName;
    }

    public CreateDatastoreRequest withDatastoreName(String datastoreName) {
        this.setDatastoreName(datastoreName);
        return this;
    }

    public void setDatastoreStorage(DatastoreStorage datastoreStorage) {
        this.datastoreStorage = datastoreStorage;
    }

    public DatastoreStorage getDatastoreStorage() {
        return this.datastoreStorage;
    }

    public CreateDatastoreRequest withDatastoreStorage(DatastoreStorage datastoreStorage) {
        this.setDatastoreStorage(datastoreStorage);
        return this;
    }

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public CreateDatastoreRequest withRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDatastoreRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDatastoreRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setFileFormatConfiguration(FileFormatConfiguration fileFormatConfiguration) {
        this.fileFormatConfiguration = fileFormatConfiguration;
    }

    public FileFormatConfiguration getFileFormatConfiguration() {
        return this.fileFormatConfiguration;
    }

    public CreateDatastoreRequest withFileFormatConfiguration(FileFormatConfiguration fileFormatConfiguration) {
        this.setFileFormatConfiguration(fileFormatConfiguration);
        return this;
    }

    public void setDatastorePartitions(DatastorePartitions datastorePartitions) {
        this.datastorePartitions = datastorePartitions;
    }

    public DatastorePartitions getDatastorePartitions() {
        return this.datastorePartitions;
    }

    public CreateDatastoreRequest withDatastorePartitions(DatastorePartitions datastorePartitions) {
        this.setDatastorePartitions(datastorePartitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatastoreName() != null) {
            sb.append("DatastoreName: ").append(this.getDatastoreName()).append(",");
        }
        if (this.getDatastoreStorage() != null) {
            sb.append("DatastoreStorage: ").append(this.getDatastoreStorage()).append(",");
        }
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getFileFormatConfiguration() != null) {
            sb.append("FileFormatConfiguration: ").append(this.getFileFormatConfiguration()).append(",");
        }
        if (this.getDatastorePartitions() != null) {
            sb.append("DatastorePartitions: ").append(this.getDatastorePartitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatastoreRequest)) {
            return false;
        }
        CreateDatastoreRequest other = (CreateDatastoreRequest)obj;
        if (other.getDatastoreName() == null ^ this.getDatastoreName() == null) {
            return false;
        }
        if (other.getDatastoreName() != null && !other.getDatastoreName().equals(this.getDatastoreName())) {
            return false;
        }
        if (other.getDatastoreStorage() == null ^ this.getDatastoreStorage() == null) {
            return false;
        }
        if (other.getDatastoreStorage() != null && !other.getDatastoreStorage().equals(this.getDatastoreStorage())) {
            return false;
        }
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getFileFormatConfiguration() == null ^ this.getFileFormatConfiguration() == null) {
            return false;
        }
        if (other.getFileFormatConfiguration() != null && !other.getFileFormatConfiguration().equals(this.getFileFormatConfiguration())) {
            return false;
        }
        if (other.getDatastorePartitions() == null ^ this.getDatastorePartitions() == null) {
            return false;
        }
        return other.getDatastorePartitions() == null || other.getDatastorePartitions().equals(this.getDatastorePartitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatastoreName() == null ? 0 : this.getDatastoreName().hashCode());
        hashCode = 31 * hashCode + (this.getDatastoreStorage() == null ? 0 : this.getDatastoreStorage().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getFileFormatConfiguration() == null ? 0 : this.getFileFormatConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDatastorePartitions() == null ? 0 : this.getDatastorePartitions().hashCode());
        return hashCode;
    }

    public CreateDatastoreRequest clone() {
        return (CreateDatastoreRequest)super.clone();
    }
}

