/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.DynamoDBv2Action;
import com.amazonaws.services.iot.model.transform.PutItemInputJsonMarshaller;

public class DynamoDBv2ActionJsonMarshaller {
    private static DynamoDBv2ActionJsonMarshaller instance;

    public void marshall(DynamoDBv2Action dynamoDBv2Action, StructuredJsonGenerator jsonGenerator) {
        if (dynamoDBv2Action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dynamoDBv2Action.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(dynamoDBv2Action.getRoleArn());
            }
            if (dynamoDBv2Action.getPutItem() != null) {
                jsonGenerator.writeFieldName("putItem");
                PutItemInputJsonMarshaller.getInstance().marshall(dynamoDBv2Action.getPutItem(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DynamoDBv2ActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DynamoDBv2ActionJsonMarshaller();
        }
        return instance;
    }
}

