/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListPolicyVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListPolicyVersionsRequest>, ListPolicyVersionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPolicyVersionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPolicyVersionsRequest> marshall(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        if (listPolicyVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPolicyVersionsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies/{policyName}/version";
        uriResourcePath = uriResourcePath.replace("{policyName}", listPolicyVersionsRequest.getPolicyName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listPolicyVersionsRequest.getPolicyName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

