/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListPolicyPrincipalsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPolicyPrincipalsRequestMarshaller
implements Marshaller<Request<ListPolicyPrincipalsRequest>, ListPolicyPrincipalsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPolicyPrincipalsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPolicyPrincipalsRequest> marshall(ListPolicyPrincipalsRequest listPolicyPrincipalsRequest) {
        if (listPolicyPrincipalsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPolicyPrincipalsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPolicyPrincipalsRequest.getPolicyName() != null) {
            request.addHeader("x-amzn-iot-policy", StringUtils.fromString((String)listPolicyPrincipalsRequest.getPolicyName()));
        }
        String uriResourcePath = "/policy-principals";
        request.setResourcePath(uriResourcePath);
        if (listPolicyPrincipalsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listPolicyPrincipalsRequest.getMarker()));
        }
        if (listPolicyPrincipalsRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listPolicyPrincipalsRequest.getPageSize()));
        }
        if (listPolicyPrincipalsRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listPolicyPrincipalsRequest.getAscendingOrder()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

