/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AlertTarget;
import com.amazonaws.services.iot.model.Behavior;
import com.amazonaws.services.iot.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateSecurityProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String securityProfileName;
    private String securityProfileDescription;
    private List<Behavior> behaviors;
    private Map<String, AlertTarget> alertTargets;
    private List<Tag> tags;

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public CreateSecurityProfileRequest withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setSecurityProfileDescription(String securityProfileDescription) {
        this.securityProfileDescription = securityProfileDescription;
    }

    public String getSecurityProfileDescription() {
        return this.securityProfileDescription;
    }

    public CreateSecurityProfileRequest withSecurityProfileDescription(String securityProfileDescription) {
        this.setSecurityProfileDescription(securityProfileDescription);
        return this;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(Collection<Behavior> behaviors) {
        if (behaviors == null) {
            this.behaviors = null;
            return;
        }
        this.behaviors = new ArrayList<Behavior>(behaviors);
    }

    public CreateSecurityProfileRequest withBehaviors(Behavior ... behaviors) {
        if (this.behaviors == null) {
            this.setBehaviors(new ArrayList<Behavior>(behaviors.length));
        }
        for (Behavior ele : behaviors) {
            this.behaviors.add(ele);
        }
        return this;
    }

    public CreateSecurityProfileRequest withBehaviors(Collection<Behavior> behaviors) {
        this.setBehaviors(behaviors);
        return this;
    }

    public Map<String, AlertTarget> getAlertTargets() {
        return this.alertTargets;
    }

    public void setAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.alertTargets = alertTargets;
    }

    public CreateSecurityProfileRequest withAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.setAlertTargets(alertTargets);
        return this;
    }

    public CreateSecurityProfileRequest addAlertTargetsEntry(String key, AlertTarget value) {
        if (null == this.alertTargets) {
            this.alertTargets = new HashMap<String, AlertTarget>();
        }
        if (this.alertTargets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.alertTargets.put(key, value);
        return this;
    }

    public CreateSecurityProfileRequest clearAlertTargetsEntries() {
        this.alertTargets = null;
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSecurityProfileRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSecurityProfileRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getSecurityProfileDescription() != null) {
            sb.append("SecurityProfileDescription: ").append(this.getSecurityProfileDescription()).append(",");
        }
        if (this.getBehaviors() != null) {
            sb.append("Behaviors: ").append(this.getBehaviors()).append(",");
        }
        if (this.getAlertTargets() != null) {
            sb.append("AlertTargets: ").append(this.getAlertTargets()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest)obj;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getSecurityProfileDescription() == null ^ this.getSecurityProfileDescription() == null) {
            return false;
        }
        if (other.getSecurityProfileDescription() != null && !other.getSecurityProfileDescription().equals(this.getSecurityProfileDescription())) {
            return false;
        }
        if (other.getBehaviors() == null ^ this.getBehaviors() == null) {
            return false;
        }
        if (other.getBehaviors() != null && !other.getBehaviors().equals(this.getBehaviors())) {
            return false;
        }
        if (other.getAlertTargets() == null ^ this.getAlertTargets() == null) {
            return false;
        }
        if (other.getAlertTargets() != null && !other.getAlertTargets().equals(this.getAlertTargets())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileDescription() == null ? 0 : this.getSecurityProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBehaviors() == null ? 0 : this.getBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getAlertTargets() == null ? 0 : this.getAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSecurityProfileRequest clone() {
        return (CreateSecurityProfileRequest)super.clone();
    }
}

