/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.JobExecutionsRolloutConfig;
import com.amazonaws.services.iot.model.JobProcessDetails;
import com.amazonaws.services.iot.model.JobStatus;
import com.amazonaws.services.iot.model.PresignedUrlConfig;
import com.amazonaws.services.iot.model.TargetSelection;
import com.amazonaws.services.iot.model.transform.JobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Job
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobArn;
    private String jobId;
    private String targetSelection;
    private String status;
    private Boolean forceCanceled;
    private String comment;
    private List<String> targets;
    private String description;
    private PresignedUrlConfig presignedUrlConfig;
    private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private Date createdAt;
    private Date lastUpdatedAt;
    private Date completedAt;
    private JobProcessDetails jobProcessDetails;

    public void setJobArn(String jobArn) {
        this.jobArn = jobArn;
    }

    public String getJobArn() {
        return this.jobArn;
    }

    public Job withJobArn(String jobArn) {
        this.setJobArn(jobArn);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Job withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setTargetSelection(String targetSelection) {
        this.targetSelection = targetSelection;
    }

    public String getTargetSelection() {
        return this.targetSelection;
    }

    public Job withTargetSelection(String targetSelection) {
        this.setTargetSelection(targetSelection);
        return this;
    }

    public Job withTargetSelection(TargetSelection targetSelection) {
        this.targetSelection = targetSelection.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Job withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Job withStatus(JobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setForceCanceled(Boolean forceCanceled) {
        this.forceCanceled = forceCanceled;
    }

    public Boolean getForceCanceled() {
        return this.forceCanceled;
    }

    public Job withForceCanceled(Boolean forceCanceled) {
        this.setForceCanceled(forceCanceled);
        return this;
    }

    public Boolean isForceCanceled() {
        return this.forceCanceled;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public Job withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public Job withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public Job withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Job withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPresignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
        this.presignedUrlConfig = presignedUrlConfig;
    }

    public PresignedUrlConfig getPresignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public Job withPresignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
        this.setPresignedUrlConfig(presignedUrlConfig);
        return this;
    }

    public void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
        this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
    }

    public JobExecutionsRolloutConfig getJobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public Job withJobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
        this.setJobExecutionsRolloutConfig(jobExecutionsRolloutConfig);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Job withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Job withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setCompletedAt(Date completedAt) {
        this.completedAt = completedAt;
    }

    public Date getCompletedAt() {
        return this.completedAt;
    }

    public Job withCompletedAt(Date completedAt) {
        this.setCompletedAt(completedAt);
        return this;
    }

    public void setJobProcessDetails(JobProcessDetails jobProcessDetails) {
        this.jobProcessDetails = jobProcessDetails;
    }

    public JobProcessDetails getJobProcessDetails() {
        return this.jobProcessDetails;
    }

    public Job withJobProcessDetails(JobProcessDetails jobProcessDetails) {
        this.setJobProcessDetails(jobProcessDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobArn() != null) {
            sb.append("JobArn: ").append(this.getJobArn()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getTargetSelection() != null) {
            sb.append("TargetSelection: ").append(this.getTargetSelection()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getForceCanceled() != null) {
            sb.append("ForceCanceled: ").append(this.getForceCanceled()).append(",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: ").append(this.getComment()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPresignedUrlConfig() != null) {
            sb.append("PresignedUrlConfig: ").append(this.getPresignedUrlConfig()).append(",");
        }
        if (this.getJobExecutionsRolloutConfig() != null) {
            sb.append("JobExecutionsRolloutConfig: ").append(this.getJobExecutionsRolloutConfig()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getCompletedAt() != null) {
            sb.append("CompletedAt: ").append(this.getCompletedAt()).append(",");
        }
        if (this.getJobProcessDetails() != null) {
            sb.append("JobProcessDetails: ").append(this.getJobProcessDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getJobArn() == null ^ this.getJobArn() == null) {
            return false;
        }
        if (other.getJobArn() != null && !other.getJobArn().equals(this.getJobArn())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getTargetSelection() == null ^ this.getTargetSelection() == null) {
            return false;
        }
        if (other.getTargetSelection() != null && !other.getTargetSelection().equals(this.getTargetSelection())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getForceCanceled() == null ^ this.getForceCanceled() == null) {
            return false;
        }
        if (other.getForceCanceled() != null && !other.getForceCanceled().equals(this.getForceCanceled())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPresignedUrlConfig() == null ^ this.getPresignedUrlConfig() == null) {
            return false;
        }
        if (other.getPresignedUrlConfig() != null && !other.getPresignedUrlConfig().equals(this.getPresignedUrlConfig())) {
            return false;
        }
        if (other.getJobExecutionsRolloutConfig() == null ^ this.getJobExecutionsRolloutConfig() == null) {
            return false;
        }
        if (other.getJobExecutionsRolloutConfig() != null && !other.getJobExecutionsRolloutConfig().equals(this.getJobExecutionsRolloutConfig())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getCompletedAt() == null ^ this.getCompletedAt() == null) {
            return false;
        }
        if (other.getCompletedAt() != null && !other.getCompletedAt().equals(this.getCompletedAt())) {
            return false;
        }
        if (other.getJobProcessDetails() == null ^ this.getJobProcessDetails() == null) {
            return false;
        }
        return other.getJobProcessDetails() == null || other.getJobProcessDetails().equals(this.getJobProcessDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobArn() == null ? 0 : this.getJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetSelection() == null ? 0 : this.getTargetSelection().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getForceCanceled() == null ? 0 : this.getForceCanceled().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPresignedUrlConfig() == null ? 0 : this.getPresignedUrlConfig().hashCode());
        hashCode = 31 * hashCode + (this.getJobExecutionsRolloutConfig() == null ? 0 : this.getJobExecutionsRolloutConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedAt() == null ? 0 : this.getCompletedAt().hashCode());
        hashCode = 31 * hashCode + (this.getJobProcessDetails() == null ? 0 : this.getJobProcessDetails().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

