/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DetachThingPrincipalRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DetachThingPrincipalRequestMarshaller
implements Marshaller<Request<DetachThingPrincipalRequest>, DetachThingPrincipalRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DetachThingPrincipalRequest> marshall(DetachThingPrincipalRequest detachThingPrincipalRequest) {
        if (detachThingPrincipalRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachThingPrincipalRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachThingPrincipalRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)detachThingPrincipalRequest.getPrincipal()));
        }
        String uriResourcePath = "/things/{thingName}/principals";
        uriResourcePath = uriResourcePath.replace("{thingName}", detachThingPrincipalRequest.getThingName() != null ? StringUtils.fromString((String)detachThingPrincipalRequest.getThingName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

