/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRule;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class TopicRuleJsonMarshaller {
    private static TopicRuleJsonMarshaller instance;

    public void marshall(TopicRule topicRule, JSONWriter jsonWriter) {
        if (topicRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Action> actionsList;
            jsonWriter.object();
            if (topicRule.getRuleName() != null) {
                jsonWriter.key("ruleName").value((Object)topicRule.getRuleName());
            }
            if (topicRule.getSql() != null) {
                jsonWriter.key("sql").value((Object)topicRule.getSql());
            }
            if (topicRule.getDescription() != null) {
                jsonWriter.key("description").value((Object)topicRule.getDescription());
            }
            if (topicRule.getCreatedAt() != null) {
                jsonWriter.key("createdAt").value(topicRule.getCreatedAt());
            }
            if ((actionsList = topicRule.getActions()) != null) {
                jsonWriter.key("actions");
                jsonWriter.array();
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (topicRule.getRuleDisabled() != null) {
                jsonWriter.key("ruleDisabled").value((Object)topicRule.getRuleDisabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TopicRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRuleJsonMarshaller();
        }
        return instance;
    }
}

