/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iot.AWSIotAsync;
import com.amazonaws.services.iot.AWSIotClient;
import com.amazonaws.services.iot.model.AcceptCertificateTransferRequest;
import com.amazonaws.services.iot.model.AttachPrincipalPolicyRequest;
import com.amazonaws.services.iot.model.AttachThingPrincipalRequest;
import com.amazonaws.services.iot.model.AttachThingPrincipalResult;
import com.amazonaws.services.iot.model.CancelCertificateTransferRequest;
import com.amazonaws.services.iot.model.CreateCertificateFromCsrRequest;
import com.amazonaws.services.iot.model.CreateCertificateFromCsrResult;
import com.amazonaws.services.iot.model.CreateKeysAndCertificateRequest;
import com.amazonaws.services.iot.model.CreateKeysAndCertificateResult;
import com.amazonaws.services.iot.model.CreatePolicyRequest;
import com.amazonaws.services.iot.model.CreatePolicyResult;
import com.amazonaws.services.iot.model.CreatePolicyVersionRequest;
import com.amazonaws.services.iot.model.CreatePolicyVersionResult;
import com.amazonaws.services.iot.model.CreateThingRequest;
import com.amazonaws.services.iot.model.CreateThingResult;
import com.amazonaws.services.iot.model.CreateTopicRuleRequest;
import com.amazonaws.services.iot.model.DeleteCertificateRequest;
import com.amazonaws.services.iot.model.DeletePolicyRequest;
import com.amazonaws.services.iot.model.DeletePolicyVersionRequest;
import com.amazonaws.services.iot.model.DeleteThingRequest;
import com.amazonaws.services.iot.model.DeleteThingResult;
import com.amazonaws.services.iot.model.DeleteTopicRuleRequest;
import com.amazonaws.services.iot.model.DescribeCertificateRequest;
import com.amazonaws.services.iot.model.DescribeCertificateResult;
import com.amazonaws.services.iot.model.DescribeEndpointRequest;
import com.amazonaws.services.iot.model.DescribeEndpointResult;
import com.amazonaws.services.iot.model.DescribeThingRequest;
import com.amazonaws.services.iot.model.DescribeThingResult;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyRequest;
import com.amazonaws.services.iot.model.DetachThingPrincipalRequest;
import com.amazonaws.services.iot.model.DetachThingPrincipalResult;
import com.amazonaws.services.iot.model.GetLoggingOptionsRequest;
import com.amazonaws.services.iot.model.GetLoggingOptionsResult;
import com.amazonaws.services.iot.model.GetPolicyRequest;
import com.amazonaws.services.iot.model.GetPolicyResult;
import com.amazonaws.services.iot.model.GetPolicyVersionRequest;
import com.amazonaws.services.iot.model.GetPolicyVersionResult;
import com.amazonaws.services.iot.model.GetTopicRuleRequest;
import com.amazonaws.services.iot.model.GetTopicRuleResult;
import com.amazonaws.services.iot.model.ListCertificatesRequest;
import com.amazonaws.services.iot.model.ListCertificatesResult;
import com.amazonaws.services.iot.model.ListPoliciesRequest;
import com.amazonaws.services.iot.model.ListPoliciesResult;
import com.amazonaws.services.iot.model.ListPolicyVersionsRequest;
import com.amazonaws.services.iot.model.ListPolicyVersionsResult;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesRequest;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesResult;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.services.iot.model.ListPrincipalThingsResult;
import com.amazonaws.services.iot.model.ListThingPrincipalsRequest;
import com.amazonaws.services.iot.model.ListThingPrincipalsResult;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.services.iot.model.ListThingsResult;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.services.iot.model.ListTopicRulesResult;
import com.amazonaws.services.iot.model.RejectCertificateTransferRequest;
import com.amazonaws.services.iot.model.ReplaceTopicRuleRequest;
import com.amazonaws.services.iot.model.SetDefaultPolicyVersionRequest;
import com.amazonaws.services.iot.model.SetLoggingOptionsRequest;
import com.amazonaws.services.iot.model.TransferCertificateRequest;
import com.amazonaws.services.iot.model.TransferCertificateResult;
import com.amazonaws.services.iot.model.UpdateCertificateRequest;
import com.amazonaws.services.iot.model.UpdateThingRequest;
import com.amazonaws.services.iot.model.UpdateThingResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSIotAsyncClient
extends AWSIotClient
implements AWSIotAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSIotAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSIotAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> acceptCertificateTransferAsync(AcceptCertificateTransferRequest request) {
        return this.acceptCertificateTransferAsync(request, null);
    }

    @Override
    public Future<Void> acceptCertificateTransferAsync(final AcceptCertificateTransferRequest request, final AsyncHandler<AcceptCertificateTransferRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.acceptCertificateTransfer(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> attachPrincipalPolicyAsync(AttachPrincipalPolicyRequest request) {
        return this.attachPrincipalPolicyAsync(request, null);
    }

    @Override
    public Future<Void> attachPrincipalPolicyAsync(final AttachPrincipalPolicyRequest request, final AsyncHandler<AttachPrincipalPolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.attachPrincipalPolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachThingPrincipalResult> attachThingPrincipalAsync(AttachThingPrincipalRequest request) {
        return this.attachThingPrincipalAsync(request, null);
    }

    @Override
    public Future<AttachThingPrincipalResult> attachThingPrincipalAsync(final AttachThingPrincipalRequest request, final AsyncHandler<AttachThingPrincipalRequest, AttachThingPrincipalResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachThingPrincipalResult>(){

            @Override
            public AttachThingPrincipalResult call() throws Exception {
                AttachThingPrincipalResult result;
                try {
                    result = AWSIotAsyncClient.this.attachThingPrincipal(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> cancelCertificateTransferAsync(CancelCertificateTransferRequest request) {
        return this.cancelCertificateTransferAsync(request, null);
    }

    @Override
    public Future<Void> cancelCertificateTransferAsync(final CancelCertificateTransferRequest request, final AsyncHandler<CancelCertificateTransferRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.cancelCertificateTransfer(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCertificateFromCsrResult> createCertificateFromCsrAsync(CreateCertificateFromCsrRequest request) {
        return this.createCertificateFromCsrAsync(request, null);
    }

    @Override
    public Future<CreateCertificateFromCsrResult> createCertificateFromCsrAsync(final CreateCertificateFromCsrRequest request, final AsyncHandler<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCertificateFromCsrResult>(){

            @Override
            public CreateCertificateFromCsrResult call() throws Exception {
                CreateCertificateFromCsrResult result;
                try {
                    result = AWSIotAsyncClient.this.createCertificateFromCsr(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeysAndCertificateResult> createKeysAndCertificateAsync(CreateKeysAndCertificateRequest request) {
        return this.createKeysAndCertificateAsync(request, null);
    }

    @Override
    public Future<CreateKeysAndCertificateResult> createKeysAndCertificateAsync(final CreateKeysAndCertificateRequest request, final AsyncHandler<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateKeysAndCertificateResult>(){

            @Override
            public CreateKeysAndCertificateResult call() throws Exception {
                CreateKeysAndCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.createKeysAndCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(CreatePolicyRequest request) {
        return this.createPolicyAsync(request, null);
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(final CreatePolicyRequest request, final AsyncHandler<CreatePolicyRequest, CreatePolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePolicyResult>(){

            @Override
            public CreatePolicyResult call() throws Exception {
                CreatePolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.createPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePolicyVersionResult> createPolicyVersionAsync(CreatePolicyVersionRequest request) {
        return this.createPolicyVersionAsync(request, null);
    }

    @Override
    public Future<CreatePolicyVersionResult> createPolicyVersionAsync(final CreatePolicyVersionRequest request, final AsyncHandler<CreatePolicyVersionRequest, CreatePolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePolicyVersionResult>(){

            @Override
            public CreatePolicyVersionResult call() throws Exception {
                CreatePolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.createPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateThingResult> createThingAsync(CreateThingRequest request) {
        return this.createThingAsync(request, null);
    }

    @Override
    public Future<CreateThingResult> createThingAsync(final CreateThingRequest request, final AsyncHandler<CreateThingRequest, CreateThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateThingResult>(){

            @Override
            public CreateThingResult call() throws Exception {
                CreateThingResult result;
                try {
                    result = AWSIotAsyncClient.this.createThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> createTopicRuleAsync(CreateTopicRuleRequest request) {
        return this.createTopicRuleAsync(request, null);
    }

    @Override
    public Future<Void> createTopicRuleAsync(final CreateTopicRuleRequest request, final AsyncHandler<CreateTopicRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.createTopicRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateAsync(request, null);
    }

    @Override
    public Future<Void> deleteCertificateAsync(final DeleteCertificateRequest request, final AsyncHandler<DeleteCertificateRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.deleteCertificate(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<Void> deletePolicyAsync(final DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.deletePolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyVersionAsync(DeletePolicyVersionRequest request) {
        return this.deletePolicyVersionAsync(request, null);
    }

    @Override
    public Future<Void> deletePolicyVersionAsync(final DeletePolicyVersionRequest request, final AsyncHandler<DeletePolicyVersionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.deletePolicyVersion(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteThingResult> deleteThingAsync(DeleteThingRequest request) {
        return this.deleteThingAsync(request, null);
    }

    @Override
    public Future<DeleteThingResult> deleteThingAsync(final DeleteThingRequest request, final AsyncHandler<DeleteThingRequest, DeleteThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteThingResult>(){

            @Override
            public DeleteThingResult call() throws Exception {
                DeleteThingResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTopicRuleAsync(DeleteTopicRuleRequest request) {
        return this.deleteTopicRuleAsync(request, null);
    }

    @Override
    public Future<Void> deleteTopicRuleAsync(final DeleteTopicRuleRequest request, final AsyncHandler<DeleteTopicRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.deleteTopicRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request) {
        return this.describeCertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(final DescribeCertificateRequest request, final AsyncHandler<DescribeCertificateRequest, DescribeCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCertificateResult>(){

            @Override
            public DescribeCertificateResult call() throws Exception {
                DescribeCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.describeCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(DescribeEndpointRequest request) {
        return this.describeEndpointAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(final DescribeEndpointRequest request, final AsyncHandler<DescribeEndpointRequest, DescribeEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEndpointResult>(){

            @Override
            public DescribeEndpointResult call() throws Exception {
                DescribeEndpointResult result;
                try {
                    result = AWSIotAsyncClient.this.describeEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeThingResult> describeThingAsync(DescribeThingRequest request) {
        return this.describeThingAsync(request, null);
    }

    @Override
    public Future<DescribeThingResult> describeThingAsync(final DescribeThingRequest request, final AsyncHandler<DescribeThingRequest, DescribeThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeThingResult>(){

            @Override
            public DescribeThingResult call() throws Exception {
                DescribeThingResult result;
                try {
                    result = AWSIotAsyncClient.this.describeThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> detachPrincipalPolicyAsync(DetachPrincipalPolicyRequest request) {
        return this.detachPrincipalPolicyAsync(request, null);
    }

    @Override
    public Future<Void> detachPrincipalPolicyAsync(final DetachPrincipalPolicyRequest request, final AsyncHandler<DetachPrincipalPolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.detachPrincipalPolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachThingPrincipalResult> detachThingPrincipalAsync(DetachThingPrincipalRequest request) {
        return this.detachThingPrincipalAsync(request, null);
    }

    @Override
    public Future<DetachThingPrincipalResult> detachThingPrincipalAsync(final DetachThingPrincipalRequest request, final AsyncHandler<DetachThingPrincipalRequest, DetachThingPrincipalResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachThingPrincipalResult>(){

            @Override
            public DetachThingPrincipalResult call() throws Exception {
                DetachThingPrincipalResult result;
                try {
                    result = AWSIotAsyncClient.this.detachThingPrincipal(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLoggingOptionsResult> getLoggingOptionsAsync(GetLoggingOptionsRequest request) {
        return this.getLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<GetLoggingOptionsResult> getLoggingOptionsAsync(final GetLoggingOptionsRequest request, final AsyncHandler<GetLoggingOptionsRequest, GetLoggingOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetLoggingOptionsResult>(){

            @Override
            public GetLoggingOptionsResult call() throws Exception {
                GetLoggingOptionsResult result;
                try {
                    result = AWSIotAsyncClient.this.getLoggingOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(final GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.getPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyVersionResult> getPolicyVersionAsync(GetPolicyVersionRequest request) {
        return this.getPolicyVersionAsync(request, null);
    }

    @Override
    public Future<GetPolicyVersionResult> getPolicyVersionAsync(final GetPolicyVersionRequest request, final AsyncHandler<GetPolicyVersionRequest, GetPolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPolicyVersionResult>(){

            @Override
            public GetPolicyVersionResult call() throws Exception {
                GetPolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.getPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTopicRuleResult> getTopicRuleAsync(GetTopicRuleRequest request) {
        return this.getTopicRuleAsync(request, null);
    }

    @Override
    public Future<GetTopicRuleResult> getTopicRuleAsync(final GetTopicRuleRequest request, final AsyncHandler<GetTopicRuleRequest, GetTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTopicRuleResult>(){

            @Override
            public GetTopicRuleResult call() throws Exception {
                GetTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.getTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request) {
        return this.listCertificatesAsync(request, null);
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(final ListCertificatesRequest request, final AsyncHandler<ListCertificatesRequest, ListCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCertificatesResult>(){

            @Override
            public ListCertificatesResult call() throws Exception {
                ListCertificatesResult result;
                try {
                    result = AWSIotAsyncClient.this.listCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request) {
        return this.listPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(final ListPoliciesRequest request, final AsyncHandler<ListPoliciesRequest, ListPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPoliciesResult>(){

            @Override
            public ListPoliciesResult call() throws Exception {
                ListPoliciesResult result;
                try {
                    result = AWSIotAsyncClient.this.listPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPolicyVersionsResult> listPolicyVersionsAsync(ListPolicyVersionsRequest request) {
        return this.listPolicyVersionsAsync(request, null);
    }

    @Override
    public Future<ListPolicyVersionsResult> listPolicyVersionsAsync(final ListPolicyVersionsRequest request, final AsyncHandler<ListPolicyVersionsRequest, ListPolicyVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPolicyVersionsResult>(){

            @Override
            public ListPolicyVersionsResult call() throws Exception {
                ListPolicyVersionsResult result;
                try {
                    result = AWSIotAsyncClient.this.listPolicyVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalPoliciesResult> listPrincipalPoliciesAsync(ListPrincipalPoliciesRequest request) {
        return this.listPrincipalPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPrincipalPoliciesResult> listPrincipalPoliciesAsync(final ListPrincipalPoliciesRequest request, final AsyncHandler<ListPrincipalPoliciesRequest, ListPrincipalPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPrincipalPoliciesResult>(){

            @Override
            public ListPrincipalPoliciesResult call() throws Exception {
                ListPrincipalPoliciesResult result;
                try {
                    result = AWSIotAsyncClient.this.listPrincipalPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalThingsResult> listPrincipalThingsAsync(ListPrincipalThingsRequest request) {
        return this.listPrincipalThingsAsync(request, null);
    }

    @Override
    public Future<ListPrincipalThingsResult> listPrincipalThingsAsync(final ListPrincipalThingsRequest request, final AsyncHandler<ListPrincipalThingsRequest, ListPrincipalThingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPrincipalThingsResult>(){

            @Override
            public ListPrincipalThingsResult call() throws Exception {
                ListPrincipalThingsResult result;
                try {
                    result = AWSIotAsyncClient.this.listPrincipalThings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListThingPrincipalsResult> listThingPrincipalsAsync(ListThingPrincipalsRequest request) {
        return this.listThingPrincipalsAsync(request, null);
    }

    @Override
    public Future<ListThingPrincipalsResult> listThingPrincipalsAsync(final ListThingPrincipalsRequest request, final AsyncHandler<ListThingPrincipalsRequest, ListThingPrincipalsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListThingPrincipalsResult>(){

            @Override
            public ListThingPrincipalsResult call() throws Exception {
                ListThingPrincipalsResult result;
                try {
                    result = AWSIotAsyncClient.this.listThingPrincipals(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListThingsResult> listThingsAsync(ListThingsRequest request) {
        return this.listThingsAsync(request, null);
    }

    @Override
    public Future<ListThingsResult> listThingsAsync(final ListThingsRequest request, final AsyncHandler<ListThingsRequest, ListThingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListThingsResult>(){

            @Override
            public ListThingsResult call() throws Exception {
                ListThingsResult result;
                try {
                    result = AWSIotAsyncClient.this.listThings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicRulesResult> listTopicRulesAsync(ListTopicRulesRequest request) {
        return this.listTopicRulesAsync(request, null);
    }

    @Override
    public Future<ListTopicRulesResult> listTopicRulesAsync(final ListTopicRulesRequest request, final AsyncHandler<ListTopicRulesRequest, ListTopicRulesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTopicRulesResult>(){

            @Override
            public ListTopicRulesResult call() throws Exception {
                ListTopicRulesResult result;
                try {
                    result = AWSIotAsyncClient.this.listTopicRules(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> rejectCertificateTransferAsync(RejectCertificateTransferRequest request) {
        return this.rejectCertificateTransferAsync(request, null);
    }

    @Override
    public Future<Void> rejectCertificateTransferAsync(final RejectCertificateTransferRequest request, final AsyncHandler<RejectCertificateTransferRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.rejectCertificateTransfer(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> replaceTopicRuleAsync(ReplaceTopicRuleRequest request) {
        return this.replaceTopicRuleAsync(request, null);
    }

    @Override
    public Future<Void> replaceTopicRuleAsync(final ReplaceTopicRuleRequest request, final AsyncHandler<ReplaceTopicRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.replaceTopicRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setDefaultPolicyVersionAsync(SetDefaultPolicyVersionRequest request) {
        return this.setDefaultPolicyVersionAsync(request, null);
    }

    @Override
    public Future<Void> setDefaultPolicyVersionAsync(final SetDefaultPolicyVersionRequest request, final AsyncHandler<SetDefaultPolicyVersionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.setDefaultPolicyVersion(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setLoggingOptionsAsync(SetLoggingOptionsRequest request) {
        return this.setLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<Void> setLoggingOptionsAsync(final SetLoggingOptionsRequest request, final AsyncHandler<SetLoggingOptionsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.setLoggingOptions(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TransferCertificateResult> transferCertificateAsync(TransferCertificateRequest request) {
        return this.transferCertificateAsync(request, null);
    }

    @Override
    public Future<TransferCertificateResult> transferCertificateAsync(final TransferCertificateRequest request, final AsyncHandler<TransferCertificateRequest, TransferCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<TransferCertificateResult>(){

            @Override
            public TransferCertificateResult call() throws Exception {
                TransferCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.transferCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateCertificateAsync(UpdateCertificateRequest request) {
        return this.updateCertificateAsync(request, null);
    }

    @Override
    public Future<Void> updateCertificateAsync(final UpdateCertificateRequest request, final AsyncHandler<UpdateCertificateRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotAsyncClient.this.updateCertificate(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateThingResult> updateThingAsync(UpdateThingRequest request) {
        return this.updateThingAsync(request, null);
    }

    @Override
    public Future<UpdateThingResult> updateThingAsync(final UpdateThingRequest request, final AsyncHandler<UpdateThingRequest, UpdateThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateThingResult>(){

            @Override
            public UpdateThingResult call() throws Exception {
                UpdateThingResult result;
                try {
                    result = AWSIotAsyncClient.this.updateThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

