/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.ResourceState;

@SdkInternalApi
public class ResourceStateMarshaller {
    private static final MarshallingInfo<StructuredPojo> EC2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2").build();
    private static final MarshallingInfo<StructuredPojo> ECR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ecr").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDACODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaCode").build();
    private static final ResourceStateMarshaller instance = new ResourceStateMarshaller();

    public static ResourceStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceState resourceState, ProtocolMarshaller protocolMarshaller) {
        if (resourceState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceState.getEc2(), EC2_BINDING);
            protocolMarshaller.marshall((Object)resourceState.getEcr(), ECR_BINDING);
            protocolMarshaller.marshall((Object)resourceState.getLambda(), LAMBDA_BINDING);
            protocolMarshaller.marshall((Object)resourceState.getLambdaCode(), LAMBDACODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

