/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.Component;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ComponentMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> CHANGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("changeDescription").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<List> SUPPORTEDOSVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedOsVersions").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owner").build();
    private static final MarshallingInfo<String> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("data").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encrypted").build();
    private static final MarshallingInfo<String> DATECREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dateCreated").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> PUBLISHER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publisher").build();
    private static final MarshallingInfo<Boolean> OBFUSCATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("obfuscate").build();
    private static final ComponentMarshaller instance = new ComponentMarshaller();

    public static ComponentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Component component, ProtocolMarshaller protocolMarshaller) {
        if (component == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)component.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)component.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)component.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)component.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)component.getChangeDescription(), CHANGEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)component.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)component.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(component.getSupportedOsVersions(), SUPPORTEDOSVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)component.getState(), STATE_BINDING);
            protocolMarshaller.marshall(component.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)component.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)component.getData(), DATA_BINDING);
            protocolMarshaller.marshall((Object)component.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)component.getEncrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)component.getDateCreated(), DATECREATED_BINDING);
            protocolMarshaller.marshall(component.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)component.getPublisher(), PUBLISHER_BINDING);
            protocolMarshaller.marshall((Object)component.getObfuscate(), OBFUSCATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

