/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.ListGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListGroupsRequestMarshaller
implements Marshaller<Request<ListGroupsRequest>, ListGroupsRequest> {
    public Request<ListGroupsRequest> marshall(ListGroupsRequest listGroupsRequest) {
        if (listGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listGroupsRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "ListGroups");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupsRequest.getPathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listGroupsRequest.getPathPrefix()));
        }
        if (listGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listGroupsRequest.getMarker()));
        }
        if (listGroupsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listGroupsRequest.getMaxItems()));
        }
        return request;
    }
}

