/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.amazonaws.services.identitymanagement.model.SimulatePrincipalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SimulatePrincipalPolicyRequestMarshaller
implements Marshaller<Request<SimulatePrincipalPolicyRequest>, SimulatePrincipalPolicyRequest> {
    public Request<SimulatePrincipalPolicyRequest> marshall(SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) {
        if (simulatePrincipalPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)simulatePrincipalPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "SimulatePrincipalPolicy");
        request.addParameter("Version", "2010-05-08");
        if (simulatePrincipalPolicyRequest.getPolicySourceArn() != null) {
            request.addParameter("PolicySourceArn", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getPolicySourceArn()));
        }
        List<String> policyInputListList = simulatePrincipalPolicyRequest.getPolicyInputList();
        int policyInputListListIndex = 1;
        for (String policyInputListListValue : policyInputListList) {
            if (policyInputListListValue != null) {
                request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
            }
            ++policyInputListListIndex;
        }
        List<String> actionNamesList = simulatePrincipalPolicyRequest.getActionNames();
        int actionNamesListIndex = 1;
        for (String actionNamesListValue : actionNamesList) {
            if (actionNamesListValue != null) {
                request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
            }
            ++actionNamesListIndex;
        }
        List<String> resourceArnsList = simulatePrincipalPolicyRequest.getResourceArns();
        int resourceArnsListIndex = 1;
        for (String resourceArnsListValue : resourceArnsList) {
            if (resourceArnsListValue != null) {
                request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
            }
            ++resourceArnsListIndex;
        }
        if (simulatePrincipalPolicyRequest.getResourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourcePolicy()));
        }
        if (simulatePrincipalPolicyRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourceOwner()));
        }
        if (simulatePrincipalPolicyRequest.getCallerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getCallerArn()));
        }
        List<ContextEntry> contextEntriesList = simulatePrincipalPolicyRequest.getContextEntries();
        int contextEntriesListIndex = 1;
        for (ContextEntry contextEntriesListValue : contextEntriesList) {
            ContextEntry contextEntryMember = contextEntriesListValue;
            if (contextEntryMember != null) {
                if (contextEntryMember.getContextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString((String)contextEntryMember.getContextKeyName()));
                }
                List<String> contextKeyValuesList = contextEntryMember.getContextKeyValues();
                int contextKeyValuesListIndex = 1;
                for (String contextKeyValuesListValue : contextKeyValuesList) {
                    if (contextKeyValuesListValue != null) {
                        request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                    }
                    ++contextKeyValuesListIndex;
                }
                if (contextEntryMember.getContextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString((String)contextEntryMember.getContextKeyType()));
                }
            }
            ++contextEntriesListIndex;
        }
        if (simulatePrincipalPolicyRequest.getResourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourceHandlingOption()));
        }
        if (simulatePrincipalPolicyRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulatePrincipalPolicyRequest.getMaxItems()));
        }
        if (simulatePrincipalPolicyRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getMarker()));
        }
        return request;
    }
}

