/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.healthlake.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.healthlake.model.OutputDataConfig;

@SdkInternalApi
public class OutputDataConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Configuration").build();
    private static final OutputDataConfigMarshaller instance = new OutputDataConfigMarshaller();

    public static OutputDataConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputDataConfig outputDataConfig, ProtocolMarshaller protocolMarshaller) {
        if (outputDataConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputDataConfig.getS3Configuration(), S3CONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

