/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.healthlake;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.healthlake.AmazonHealthLakeAsync;
import com.amazonaws.services.healthlake.AmazonHealthLakeAsyncClientBuilder;
import com.amazonaws.services.healthlake.AmazonHealthLakeClient;
import com.amazonaws.services.healthlake.model.CreateFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.CreateFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DeleteFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.DeleteFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRExportJobRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRExportJobResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRImportJobRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRImportJobResult;
import com.amazonaws.services.healthlake.model.ListFHIRDatastoresRequest;
import com.amazonaws.services.healthlake.model.ListFHIRDatastoresResult;
import com.amazonaws.services.healthlake.model.StartFHIRExportJobRequest;
import com.amazonaws.services.healthlake.model.StartFHIRExportJobResult;
import com.amazonaws.services.healthlake.model.StartFHIRImportJobRequest;
import com.amazonaws.services.healthlake.model.StartFHIRImportJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonHealthLakeAsyncClient
extends AmazonHealthLakeClient
implements AmazonHealthLakeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonHealthLakeAsyncClientBuilder asyncBuilder() {
        return AmazonHealthLakeAsyncClientBuilder.standard();
    }

    AmazonHealthLakeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonHealthLakeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateFHIRDatastoreResult> createFHIRDatastoreAsync(CreateFHIRDatastoreRequest request) {
        return this.createFHIRDatastoreAsync(request, null);
    }

    @Override
    public Future<CreateFHIRDatastoreResult> createFHIRDatastoreAsync(CreateFHIRDatastoreRequest request, final AsyncHandler<CreateFHIRDatastoreRequest, CreateFHIRDatastoreResult> asyncHandler) {
        final CreateFHIRDatastoreRequest finalRequest = (CreateFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFHIRDatastoreResult>(){

            @Override
            public CreateFHIRDatastoreResult call() throws Exception {
                CreateFHIRDatastoreResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeCreateFHIRDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFHIRDatastoreResult> deleteFHIRDatastoreAsync(DeleteFHIRDatastoreRequest request) {
        return this.deleteFHIRDatastoreAsync(request, null);
    }

    @Override
    public Future<DeleteFHIRDatastoreResult> deleteFHIRDatastoreAsync(DeleteFHIRDatastoreRequest request, final AsyncHandler<DeleteFHIRDatastoreRequest, DeleteFHIRDatastoreResult> asyncHandler) {
        final DeleteFHIRDatastoreRequest finalRequest = (DeleteFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFHIRDatastoreResult>(){

            @Override
            public DeleteFHIRDatastoreResult call() throws Exception {
                DeleteFHIRDatastoreResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeDeleteFHIRDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFHIRDatastoreResult> describeFHIRDatastoreAsync(DescribeFHIRDatastoreRequest request) {
        return this.describeFHIRDatastoreAsync(request, null);
    }

    @Override
    public Future<DescribeFHIRDatastoreResult> describeFHIRDatastoreAsync(DescribeFHIRDatastoreRequest request, final AsyncHandler<DescribeFHIRDatastoreRequest, DescribeFHIRDatastoreResult> asyncHandler) {
        final DescribeFHIRDatastoreRequest finalRequest = (DescribeFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFHIRDatastoreResult>(){

            @Override
            public DescribeFHIRDatastoreResult call() throws Exception {
                DescribeFHIRDatastoreResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeDescribeFHIRDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFHIRExportJobResult> describeFHIRExportJobAsync(DescribeFHIRExportJobRequest request) {
        return this.describeFHIRExportJobAsync(request, null);
    }

    @Override
    public Future<DescribeFHIRExportJobResult> describeFHIRExportJobAsync(DescribeFHIRExportJobRequest request, final AsyncHandler<DescribeFHIRExportJobRequest, DescribeFHIRExportJobResult> asyncHandler) {
        final DescribeFHIRExportJobRequest finalRequest = (DescribeFHIRExportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFHIRExportJobResult>(){

            @Override
            public DescribeFHIRExportJobResult call() throws Exception {
                DescribeFHIRExportJobResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeDescribeFHIRExportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFHIRImportJobResult> describeFHIRImportJobAsync(DescribeFHIRImportJobRequest request) {
        return this.describeFHIRImportJobAsync(request, null);
    }

    @Override
    public Future<DescribeFHIRImportJobResult> describeFHIRImportJobAsync(DescribeFHIRImportJobRequest request, final AsyncHandler<DescribeFHIRImportJobRequest, DescribeFHIRImportJobResult> asyncHandler) {
        final DescribeFHIRImportJobRequest finalRequest = (DescribeFHIRImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFHIRImportJobResult>(){

            @Override
            public DescribeFHIRImportJobResult call() throws Exception {
                DescribeFHIRImportJobResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeDescribeFHIRImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFHIRDatastoresResult> listFHIRDatastoresAsync(ListFHIRDatastoresRequest request) {
        return this.listFHIRDatastoresAsync(request, null);
    }

    @Override
    public Future<ListFHIRDatastoresResult> listFHIRDatastoresAsync(ListFHIRDatastoresRequest request, final AsyncHandler<ListFHIRDatastoresRequest, ListFHIRDatastoresResult> asyncHandler) {
        final ListFHIRDatastoresRequest finalRequest = (ListFHIRDatastoresRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFHIRDatastoresResult>(){

            @Override
            public ListFHIRDatastoresResult call() throws Exception {
                ListFHIRDatastoresResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeListFHIRDatastores(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFHIRExportJobResult> startFHIRExportJobAsync(StartFHIRExportJobRequest request) {
        return this.startFHIRExportJobAsync(request, null);
    }

    @Override
    public Future<StartFHIRExportJobResult> startFHIRExportJobAsync(StartFHIRExportJobRequest request, final AsyncHandler<StartFHIRExportJobRequest, StartFHIRExportJobResult> asyncHandler) {
        final StartFHIRExportJobRequest finalRequest = (StartFHIRExportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFHIRExportJobResult>(){

            @Override
            public StartFHIRExportJobResult call() throws Exception {
                StartFHIRExportJobResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeStartFHIRExportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFHIRImportJobResult> startFHIRImportJobAsync(StartFHIRImportJobRequest request) {
        return this.startFHIRImportJobAsync(request, null);
    }

    @Override
    public Future<StartFHIRImportJobResult> startFHIRImportJobAsync(StartFHIRImportJobRequest request, final AsyncHandler<StartFHIRImportJobRequest, StartFHIRImportJobResult> asyncHandler) {
        final StartFHIRImportJobRequest finalRequest = (StartFHIRImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFHIRImportJobResult>(){

            @Override
            public StartFHIRImportJobResult call() throws Exception {
                StartFHIRImportJobResult result = null;
                try {
                    result = AmazonHealthLakeAsyncClient.this.executeStartFHIRImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

