/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.health.model.DateTimeRange;
import com.amazonaws.services.health.model.EventStatusCode;
import com.amazonaws.services.health.model.EventTypeCategory;
import com.amazonaws.services.health.model.transform.EventFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EventFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> eventArns;
    private List<String> eventTypeCodes;
    private List<String> services;
    private List<String> regions;
    private List<String> availabilityZones;
    private List<DateTimeRange> startTimes;
    private List<DateTimeRange> endTimes;
    private List<DateTimeRange> lastUpdatedTimes;
    private List<String> entityArns;
    private List<String> entityValues;
    private List<String> eventTypeCategories;
    private List<Map<String, String>> tags;
    private List<String> eventStatusCodes;

    public List<String> getEventArns() {
        return this.eventArns;
    }

    public void setEventArns(Collection<String> eventArns) {
        if (eventArns == null) {
            this.eventArns = null;
            return;
        }
        this.eventArns = new ArrayList<String>(eventArns);
    }

    public EventFilter withEventArns(String ... eventArns) {
        if (this.eventArns == null) {
            this.setEventArns(new ArrayList<String>(eventArns.length));
        }
        for (String ele : eventArns) {
            this.eventArns.add(ele);
        }
        return this;
    }

    public EventFilter withEventArns(Collection<String> eventArns) {
        this.setEventArns(eventArns);
        return this;
    }

    public List<String> getEventTypeCodes() {
        return this.eventTypeCodes;
    }

    public void setEventTypeCodes(Collection<String> eventTypeCodes) {
        if (eventTypeCodes == null) {
            this.eventTypeCodes = null;
            return;
        }
        this.eventTypeCodes = new ArrayList<String>(eventTypeCodes);
    }

    public EventFilter withEventTypeCodes(String ... eventTypeCodes) {
        if (this.eventTypeCodes == null) {
            this.setEventTypeCodes(new ArrayList<String>(eventTypeCodes.length));
        }
        for (String ele : eventTypeCodes) {
            this.eventTypeCodes.add(ele);
        }
        return this;
    }

    public EventFilter withEventTypeCodes(Collection<String> eventTypeCodes) {
        this.setEventTypeCodes(eventTypeCodes);
        return this;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new ArrayList<String>(services);
    }

    public EventFilter withServices(String ... services) {
        if (this.services == null) {
            this.setServices(new ArrayList<String>(services.length));
        }
        for (String ele : services) {
            this.services.add(ele);
        }
        return this;
    }

    public EventFilter withServices(Collection<String> services) {
        this.setServices(services);
        return this;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public EventFilter withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public EventFilter withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<String>(availabilityZones);
    }

    public EventFilter withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public EventFilter withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<DateTimeRange> getStartTimes() {
        return this.startTimes;
    }

    public void setStartTimes(Collection<DateTimeRange> startTimes) {
        if (startTimes == null) {
            this.startTimes = null;
            return;
        }
        this.startTimes = new ArrayList<DateTimeRange>(startTimes);
    }

    public EventFilter withStartTimes(DateTimeRange ... startTimes) {
        if (this.startTimes == null) {
            this.setStartTimes(new ArrayList<DateTimeRange>(startTimes.length));
        }
        for (DateTimeRange ele : startTimes) {
            this.startTimes.add(ele);
        }
        return this;
    }

    public EventFilter withStartTimes(Collection<DateTimeRange> startTimes) {
        this.setStartTimes(startTimes);
        return this;
    }

    public List<DateTimeRange> getEndTimes() {
        return this.endTimes;
    }

    public void setEndTimes(Collection<DateTimeRange> endTimes) {
        if (endTimes == null) {
            this.endTimes = null;
            return;
        }
        this.endTimes = new ArrayList<DateTimeRange>(endTimes);
    }

    public EventFilter withEndTimes(DateTimeRange ... endTimes) {
        if (this.endTimes == null) {
            this.setEndTimes(new ArrayList<DateTimeRange>(endTimes.length));
        }
        for (DateTimeRange ele : endTimes) {
            this.endTimes.add(ele);
        }
        return this;
    }

    public EventFilter withEndTimes(Collection<DateTimeRange> endTimes) {
        this.setEndTimes(endTimes);
        return this;
    }

    public List<DateTimeRange> getLastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public void setLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
        if (lastUpdatedTimes == null) {
            this.lastUpdatedTimes = null;
            return;
        }
        this.lastUpdatedTimes = new ArrayList<DateTimeRange>(lastUpdatedTimes);
    }

    public EventFilter withLastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
        if (this.lastUpdatedTimes == null) {
            this.setLastUpdatedTimes(new ArrayList<DateTimeRange>(lastUpdatedTimes.length));
        }
        for (DateTimeRange ele : lastUpdatedTimes) {
            this.lastUpdatedTimes.add(ele);
        }
        return this;
    }

    public EventFilter withLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
        this.setLastUpdatedTimes(lastUpdatedTimes);
        return this;
    }

    public List<String> getEntityArns() {
        return this.entityArns;
    }

    public void setEntityArns(Collection<String> entityArns) {
        if (entityArns == null) {
            this.entityArns = null;
            return;
        }
        this.entityArns = new ArrayList<String>(entityArns);
    }

    public EventFilter withEntityArns(String ... entityArns) {
        if (this.entityArns == null) {
            this.setEntityArns(new ArrayList<String>(entityArns.length));
        }
        for (String ele : entityArns) {
            this.entityArns.add(ele);
        }
        return this;
    }

    public EventFilter withEntityArns(Collection<String> entityArns) {
        this.setEntityArns(entityArns);
        return this;
    }

    public List<String> getEntityValues() {
        return this.entityValues;
    }

    public void setEntityValues(Collection<String> entityValues) {
        if (entityValues == null) {
            this.entityValues = null;
            return;
        }
        this.entityValues = new ArrayList<String>(entityValues);
    }

    public EventFilter withEntityValues(String ... entityValues) {
        if (this.entityValues == null) {
            this.setEntityValues(new ArrayList<String>(entityValues.length));
        }
        for (String ele : entityValues) {
            this.entityValues.add(ele);
        }
        return this;
    }

    public EventFilter withEntityValues(Collection<String> entityValues) {
        this.setEntityValues(entityValues);
        return this;
    }

    public List<String> getEventTypeCategories() {
        return this.eventTypeCategories;
    }

    public void setEventTypeCategories(Collection<String> eventTypeCategories) {
        if (eventTypeCategories == null) {
            this.eventTypeCategories = null;
            return;
        }
        this.eventTypeCategories = new ArrayList<String>(eventTypeCategories);
    }

    public EventFilter withEventTypeCategories(String ... eventTypeCategories) {
        if (this.eventTypeCategories == null) {
            this.setEventTypeCategories(new ArrayList<String>(eventTypeCategories.length));
        }
        for (String ele : eventTypeCategories) {
            this.eventTypeCategories.add(ele);
        }
        return this;
    }

    public EventFilter withEventTypeCategories(Collection<String> eventTypeCategories) {
        this.setEventTypeCategories(eventTypeCategories);
        return this;
    }

    public EventFilter withEventTypeCategories(EventTypeCategory ... eventTypeCategories) {
        ArrayList<String> eventTypeCategoriesCopy = new ArrayList<String>(eventTypeCategories.length);
        for (EventTypeCategory value : eventTypeCategories) {
            eventTypeCategoriesCopy.add(value.toString());
        }
        if (this.getEventTypeCategories() == null) {
            this.setEventTypeCategories(eventTypeCategoriesCopy);
        } else {
            this.getEventTypeCategories().addAll(eventTypeCategoriesCopy);
        }
        return this;
    }

    public List<Map<String, String>> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Map<String, String>> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Map<String, String>>(tags);
    }

    public EventFilter withTags(Map<String, String> ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Map<String, String>>(tags.length));
        }
        for (Map<String, String> ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public EventFilter withTags(Collection<Map<String, String>> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getEventStatusCodes() {
        return this.eventStatusCodes;
    }

    public void setEventStatusCodes(Collection<String> eventStatusCodes) {
        if (eventStatusCodes == null) {
            this.eventStatusCodes = null;
            return;
        }
        this.eventStatusCodes = new ArrayList<String>(eventStatusCodes);
    }

    public EventFilter withEventStatusCodes(String ... eventStatusCodes) {
        if (this.eventStatusCodes == null) {
            this.setEventStatusCodes(new ArrayList<String>(eventStatusCodes.length));
        }
        for (String ele : eventStatusCodes) {
            this.eventStatusCodes.add(ele);
        }
        return this;
    }

    public EventFilter withEventStatusCodes(Collection<String> eventStatusCodes) {
        this.setEventStatusCodes(eventStatusCodes);
        return this;
    }

    public EventFilter withEventStatusCodes(EventStatusCode ... eventStatusCodes) {
        ArrayList<String> eventStatusCodesCopy = new ArrayList<String>(eventStatusCodes.length);
        for (EventStatusCode value : eventStatusCodes) {
            eventStatusCodesCopy.add(value.toString());
        }
        if (this.getEventStatusCodes() == null) {
            this.setEventStatusCodes(eventStatusCodesCopy);
        } else {
            this.getEventStatusCodes().addAll(eventStatusCodesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventArns() != null) {
            sb.append("EventArns: ").append(this.getEventArns()).append(",");
        }
        if (this.getEventTypeCodes() != null) {
            sb.append("EventTypeCodes: ").append(this.getEventTypeCodes()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getStartTimes() != null) {
            sb.append("StartTimes: ").append(this.getStartTimes()).append(",");
        }
        if (this.getEndTimes() != null) {
            sb.append("EndTimes: ").append(this.getEndTimes()).append(",");
        }
        if (this.getLastUpdatedTimes() != null) {
            sb.append("LastUpdatedTimes: ").append(this.getLastUpdatedTimes()).append(",");
        }
        if (this.getEntityArns() != null) {
            sb.append("EntityArns: ").append(this.getEntityArns()).append(",");
        }
        if (this.getEntityValues() != null) {
            sb.append("EntityValues: ").append(this.getEntityValues()).append(",");
        }
        if (this.getEventTypeCategories() != null) {
            sb.append("EventTypeCategories: ").append(this.getEventTypeCategories()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEventStatusCodes() != null) {
            sb.append("EventStatusCodes: ").append(this.getEventStatusCodes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        if (other.getEventArns() == null ^ this.getEventArns() == null) {
            return false;
        }
        if (other.getEventArns() != null && !other.getEventArns().equals(this.getEventArns())) {
            return false;
        }
        if (other.getEventTypeCodes() == null ^ this.getEventTypeCodes() == null) {
            return false;
        }
        if (other.getEventTypeCodes() != null && !other.getEventTypeCodes().equals(this.getEventTypeCodes())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getStartTimes() == null ^ this.getStartTimes() == null) {
            return false;
        }
        if (other.getStartTimes() != null && !other.getStartTimes().equals(this.getStartTimes())) {
            return false;
        }
        if (other.getEndTimes() == null ^ this.getEndTimes() == null) {
            return false;
        }
        if (other.getEndTimes() != null && !other.getEndTimes().equals(this.getEndTimes())) {
            return false;
        }
        if (other.getLastUpdatedTimes() == null ^ this.getLastUpdatedTimes() == null) {
            return false;
        }
        if (other.getLastUpdatedTimes() != null && !other.getLastUpdatedTimes().equals(this.getLastUpdatedTimes())) {
            return false;
        }
        if (other.getEntityArns() == null ^ this.getEntityArns() == null) {
            return false;
        }
        if (other.getEntityArns() != null && !other.getEntityArns().equals(this.getEntityArns())) {
            return false;
        }
        if (other.getEntityValues() == null ^ this.getEntityValues() == null) {
            return false;
        }
        if (other.getEntityValues() != null && !other.getEntityValues().equals(this.getEntityValues())) {
            return false;
        }
        if (other.getEventTypeCategories() == null ^ this.getEventTypeCategories() == null) {
            return false;
        }
        if (other.getEventTypeCategories() != null && !other.getEventTypeCategories().equals(this.getEventTypeCategories())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEventStatusCodes() == null ^ this.getEventStatusCodes() == null) {
            return false;
        }
        return other.getEventStatusCodes() == null || other.getEventStatusCodes().equals(this.getEventStatusCodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventArns() == null ? 0 : this.getEventArns().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypeCodes() == null ? 0 : this.getEventTypeCodes().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimes() == null ? 0 : this.getStartTimes().hashCode());
        hashCode = 31 * hashCode + (this.getEndTimes() == null ? 0 : this.getEndTimes().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimes() == null ? 0 : this.getLastUpdatedTimes().hashCode());
        hashCode = 31 * hashCode + (this.getEntityArns() == null ? 0 : this.getEntityArns().hashCode());
        hashCode = 31 * hashCode + (this.getEntityValues() == null ? 0 : this.getEntityValues().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypeCategories() == null ? 0 : this.getEventTypeCategories().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEventStatusCodes() == null ? 0 : this.getEventStatusCodes().hashCode());
        return hashCode;
    }

    public EventFilter clone() {
        try {
            return (EventFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

