/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.Mapping;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class MappingJsonUnmarshaller
implements Unmarshaller<Mapping, JsonUnmarshallerContext> {
    private static MappingJsonUnmarshaller instance;

    public Mapping unmarshall(JsonUnmarshallerContext context) throws Exception {
        Mapping mapping = new Mapping();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ToKey", targetDepth)) {
                    context.nextToken();
                    mapping.setToKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FromPath", targetDepth)) {
                    context.nextToken();
                    mapping.setFromPath(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("FromType", targetDepth)) {
                    context.nextToken();
                    mapping.setFromType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ToType", targetDepth)) {
                    context.nextToken();
                    mapping.setToType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Dropped", targetDepth)) {
                    context.nextToken();
                    mapping.setDropped((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Children", targetDepth)) {
                    context.nextToken();
                    mapping.setChildren(new ListUnmarshaller((Unmarshaller)MappingJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return mapping;
    }

    public static MappingJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MappingJsonUnmarshaller();
        }
        return instance;
    }
}

