/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.IcebergTargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IcebergTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> paths;
    private String connectionName;
    private List<String> exclusions;
    private Integer maximumTraversalDepth;

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Collection<String> paths) {
        if (paths == null) {
            this.paths = null;
            return;
        }
        this.paths = new ArrayList<String>(paths);
    }

    public IcebergTarget withPaths(String ... paths) {
        if (this.paths == null) {
            this.setPaths(new ArrayList<String>(paths.length));
        }
        for (String ele : paths) {
            this.paths.add(ele);
        }
        return this;
    }

    public IcebergTarget withPaths(Collection<String> paths) {
        this.setPaths(paths);
        return this;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public IcebergTarget withConnectionName(String connectionName) {
        this.setConnectionName(connectionName);
        return this;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<String> exclusions) {
        if (exclusions == null) {
            this.exclusions = null;
            return;
        }
        this.exclusions = new ArrayList<String>(exclusions);
    }

    public IcebergTarget withExclusions(String ... exclusions) {
        if (this.exclusions == null) {
            this.setExclusions(new ArrayList<String>(exclusions.length));
        }
        for (String ele : exclusions) {
            this.exclusions.add(ele);
        }
        return this;
    }

    public IcebergTarget withExclusions(Collection<String> exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public void setMaximumTraversalDepth(Integer maximumTraversalDepth) {
        this.maximumTraversalDepth = maximumTraversalDepth;
    }

    public Integer getMaximumTraversalDepth() {
        return this.maximumTraversalDepth;
    }

    public IcebergTarget withMaximumTraversalDepth(Integer maximumTraversalDepth) {
        this.setMaximumTraversalDepth(maximumTraversalDepth);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPaths() != null) {
            sb.append("Paths: ").append(this.getPaths()).append(",");
        }
        if (this.getConnectionName() != null) {
            sb.append("ConnectionName: ").append(this.getConnectionName()).append(",");
        }
        if (this.getExclusions() != null) {
            sb.append("Exclusions: ").append(this.getExclusions()).append(",");
        }
        if (this.getMaximumTraversalDepth() != null) {
            sb.append("MaximumTraversalDepth: ").append(this.getMaximumTraversalDepth());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergTarget)) {
            return false;
        }
        IcebergTarget other = (IcebergTarget)obj;
        if (other.getPaths() == null ^ this.getPaths() == null) {
            return false;
        }
        if (other.getPaths() != null && !other.getPaths().equals(this.getPaths())) {
            return false;
        }
        if (other.getConnectionName() == null ^ this.getConnectionName() == null) {
            return false;
        }
        if (other.getConnectionName() != null && !other.getConnectionName().equals(this.getConnectionName())) {
            return false;
        }
        if (other.getExclusions() == null ^ this.getExclusions() == null) {
            return false;
        }
        if (other.getExclusions() != null && !other.getExclusions().equals(this.getExclusions())) {
            return false;
        }
        if (other.getMaximumTraversalDepth() == null ^ this.getMaximumTraversalDepth() == null) {
            return false;
        }
        return other.getMaximumTraversalDepth() == null || other.getMaximumTraversalDepth().equals(this.getMaximumTraversalDepth());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPaths() == null ? 0 : this.getPaths().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionName() == null ? 0 : this.getConnectionName().hashCode());
        hashCode = 31 * hashCode + (this.getExclusions() == null ? 0 : this.getExclusions().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumTraversalDepth() == null ? 0 : this.getMaximumTraversalDepth().hashCode());
        return hashCode;
    }

    public IcebergTarget clone() {
        try {
            return (IcebergTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IcebergTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

