/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.S3CatalogSource;

@SdkInternalApi
public class S3CatalogSourceMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<String> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<String> PARTITIONPREDICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionPredicate").build();
    private static final MarshallingInfo<StructuredPojo> ADDITIONALOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalOptions").build();
    private static final S3CatalogSourceMarshaller instance = new S3CatalogSourceMarshaller();

    public static S3CatalogSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3CatalogSource s3CatalogSource, ProtocolMarshaller protocolMarshaller) {
        if (s3CatalogSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3CatalogSource.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)s3CatalogSource.getDatabase(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)s3CatalogSource.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall((Object)s3CatalogSource.getPartitionPredicate(), PARTITIONPREDICATE_BINDING);
            protocolMarshaller.marshall((Object)s3CatalogSource.getAdditionalOptions(), ADDITIONALOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

