/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.globalaccelerator.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateListenerRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your accelerator.
     * </p>
     */
    private String acceleratorArn;
    /**
     * <p>
     * The list of port ranges to support for connections from clients to your accelerator.
     * </p>
     */
    private java.util.List<PortRange> portRanges;
    /**
     * <p>
     * The protocol for connections from clients to your accelerator.
     * </p>
     */
    private String protocol;
    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     */
    private String clientAffinity;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     */
    private String idempotencyToken;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your accelerator.
     * </p>
     * 
     * @param acceleratorArn
     *        The Amazon Resource Name (ARN) of your accelerator.
     */

    public void setAcceleratorArn(String acceleratorArn) {
        this.acceleratorArn = acceleratorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your accelerator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your accelerator.
     */

    public String getAcceleratorArn() {
        return this.acceleratorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your accelerator.
     * </p>
     * 
     * @param acceleratorArn
     *        The Amazon Resource Name (ARN) of your accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateListenerRequest withAcceleratorArn(String acceleratorArn) {
        setAcceleratorArn(acceleratorArn);
        return this;
    }

    /**
     * <p>
     * The list of port ranges to support for connections from clients to your accelerator.
     * </p>
     * 
     * @return The list of port ranges to support for connections from clients to your accelerator.
     */

    public java.util.List<PortRange> getPortRanges() {
        return portRanges;
    }

    /**
     * <p>
     * The list of port ranges to support for connections from clients to your accelerator.
     * </p>
     * 
     * @param portRanges
     *        The list of port ranges to support for connections from clients to your accelerator.
     */

    public void setPortRanges(java.util.Collection<PortRange> portRanges) {
        if (portRanges == null) {
            this.portRanges = null;
            return;
        }

        this.portRanges = new java.util.ArrayList<PortRange>(portRanges);
    }

    /**
     * <p>
     * The list of port ranges to support for connections from clients to your accelerator.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPortRanges(java.util.Collection)} or {@link #withPortRanges(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param portRanges
     *        The list of port ranges to support for connections from clients to your accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateListenerRequest withPortRanges(PortRange... portRanges) {
        if (this.portRanges == null) {
            setPortRanges(new java.util.ArrayList<PortRange>(portRanges.length));
        }
        for (PortRange ele : portRanges) {
            this.portRanges.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of port ranges to support for connections from clients to your accelerator.
     * </p>
     * 
     * @param portRanges
     *        The list of port ranges to support for connections from clients to your accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateListenerRequest withPortRanges(java.util.Collection<PortRange> portRanges) {
        setPortRanges(portRanges);
        return this;
    }

    /**
     * <p>
     * The protocol for connections from clients to your accelerator.
     * </p>
     * 
     * @param protocol
     *        The protocol for connections from clients to your accelerator.
     * @see Protocol
     */

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * <p>
     * The protocol for connections from clients to your accelerator.
     * </p>
     * 
     * @return The protocol for connections from clients to your accelerator.
     * @see Protocol
     */

    public String getProtocol() {
        return this.protocol;
    }

    /**
     * <p>
     * The protocol for connections from clients to your accelerator.
     * </p>
     * 
     * @param protocol
     *        The protocol for connections from clients to your accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Protocol
     */

    public CreateListenerRequest withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * <p>
     * The protocol for connections from clients to your accelerator.
     * </p>
     * 
     * @param protocol
     *        The protocol for connections from clients to your accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Protocol
     */

    public CreateListenerRequest withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * 
     * @param clientAffinity
     *        Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *        applications, regardless of the port and protocol of the client request. Client affinity gives you control
     *        over whether to always route each client to the same specific endpoint.</p>
     *        <p>
     *        AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *        connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *        properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *        select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *        different ports to connect to Global Accelerator, their connections might not be always routed to the same
     *        endpoint because the hash value changes.
     *        </p>
     *        <p>
     *        If you want a given client to always be routed to the same endpoint, set client affinity to
     *        <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *        the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *        hash value.
     *        </p>
     *        <p>
     *        The default value is <code>NONE</code>.
     * @see ClientAffinity
     */

    public void setClientAffinity(String clientAffinity) {
        this.clientAffinity = clientAffinity;
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * 
     * @return Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *         applications, regardless of the port and protocol of the client request. Client affinity gives you
     *         control over whether to always route each client to the same specific endpoint.</p>
     *         <p>
     *         AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *         connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *         properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *         select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *         different ports to connect to Global Accelerator, their connections might not be always routed to the
     *         same endpoint because the hash value changes.
     *         </p>
     *         <p>
     *         If you want a given client to always be routed to the same endpoint, set client affinity to
     *         <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *         the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *         hash value.
     *         </p>
     *         <p>
     *         The default value is <code>NONE</code>.
     * @see ClientAffinity
     */

    public String getClientAffinity() {
        return this.clientAffinity;
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * 
     * @param clientAffinity
     *        Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *        applications, regardless of the port and protocol of the client request. Client affinity gives you control
     *        over whether to always route each client to the same specific endpoint.</p>
     *        <p>
     *        AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *        connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *        properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *        select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *        different ports to connect to Global Accelerator, their connections might not be always routed to the same
     *        endpoint because the hash value changes.
     *        </p>
     *        <p>
     *        If you want a given client to always be routed to the same endpoint, set client affinity to
     *        <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *        the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *        hash value.
     *        </p>
     *        <p>
     *        The default value is <code>NONE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClientAffinity
     */

    public CreateListenerRequest withClientAffinity(String clientAffinity) {
        setClientAffinity(clientAffinity);
        return this;
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * 
     * @param clientAffinity
     *        Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *        applications, regardless of the port and protocol of the client request. Client affinity gives you control
     *        over whether to always route each client to the same specific endpoint.</p>
     *        <p>
     *        AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *        connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *        properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *        select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *        different ports to connect to Global Accelerator, their connections might not be always routed to the same
     *        endpoint because the hash value changes.
     *        </p>
     *        <p>
     *        If you want a given client to always be routed to the same endpoint, set client affinity to
     *        <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *        the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *        hash value.
     *        </p>
     *        <p>
     *        The default value is <code>NONE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClientAffinity
     */

    public CreateListenerRequest withClientAffinity(ClientAffinity clientAffinity) {
        this.clientAffinity = clientAffinity.toString();
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     * 
     * @param idempotencyToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *        the request.
     */

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *         the request.
     */

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     * 
     * @param idempotencyToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *        the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateListenerRequest withIdempotencyToken(String idempotencyToken) {
        setIdempotencyToken(idempotencyToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAcceleratorArn() != null)
            sb.append("AcceleratorArn: ").append(getAcceleratorArn()).append(",");
        if (getPortRanges() != null)
            sb.append("PortRanges: ").append(getPortRanges()).append(",");
        if (getProtocol() != null)
            sb.append("Protocol: ").append(getProtocol()).append(",");
        if (getClientAffinity() != null)
            sb.append("ClientAffinity: ").append(getClientAffinity()).append(",");
        if (getIdempotencyToken() != null)
            sb.append("IdempotencyToken: ").append(getIdempotencyToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateListenerRequest == false)
            return false;
        CreateListenerRequest other = (CreateListenerRequest) obj;
        if (other.getAcceleratorArn() == null ^ this.getAcceleratorArn() == null)
            return false;
        if (other.getAcceleratorArn() != null && other.getAcceleratorArn().equals(this.getAcceleratorArn()) == false)
            return false;
        if (other.getPortRanges() == null ^ this.getPortRanges() == null)
            return false;
        if (other.getPortRanges() != null && other.getPortRanges().equals(this.getPortRanges()) == false)
            return false;
        if (other.getProtocol() == null ^ this.getProtocol() == null)
            return false;
        if (other.getProtocol() != null && other.getProtocol().equals(this.getProtocol()) == false)
            return false;
        if (other.getClientAffinity() == null ^ this.getClientAffinity() == null)
            return false;
        if (other.getClientAffinity() != null && other.getClientAffinity().equals(this.getClientAffinity()) == false)
            return false;
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null)
            return false;
        if (other.getIdempotencyToken() != null && other.getIdempotencyToken().equals(this.getIdempotencyToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAcceleratorArn() == null) ? 0 : getAcceleratorArn().hashCode());
        hashCode = prime * hashCode + ((getPortRanges() == null) ? 0 : getPortRanges().hashCode());
        hashCode = prime * hashCode + ((getProtocol() == null) ? 0 : getProtocol().hashCode());
        hashCode = prime * hashCode + ((getClientAffinity() == null) ? 0 : getClientAffinity().hashCode());
        hashCode = prime * hashCode + ((getIdempotencyToken() == null) ? 0 : getIdempotencyToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateListenerRequest clone() {
        return (CreateListenerRequest) super.clone();
    }

}
