/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.globalaccelerator;

import javax.annotation.Generated;

import com.amazonaws.services.globalaccelerator.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGlobalAccelerator}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGlobalAccelerator implements AWSGlobalAccelerator {

    protected AbstractAWSGlobalAccelerator() {
    }

    @Override
    public CreateAcceleratorResult createAccelerator(CreateAcceleratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointGroupResult createEndpointGroup(CreateEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateListenerResult createListener(CreateListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAcceleratorResult deleteAccelerator(DeleteAcceleratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointGroupResult deleteEndpointGroup(DeleteEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteListenerResult deleteListener(DeleteListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAcceleratorResult describeAccelerator(DescribeAcceleratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAcceleratorAttributesResult describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointGroupResult describeEndpointGroup(DescribeEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeListenerResult describeListener(DescribeListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAcceleratorsResult listAccelerators(ListAcceleratorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointGroupsResult listEndpointGroups(ListEndpointGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListListenersResult listListeners(ListListenersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAcceleratorResult updateAccelerator(UpdateAcceleratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAcceleratorAttributesResult updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointGroupResult updateEndpointGroup(UpdateEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateListenerResult updateListener(UpdateListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
