/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.glacier.model.UploadListElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMultipartUploadsResult
implements Serializable {
    private ListWithAutoConstructFlag<UploadListElement> uploadsList;
    private String marker;

    public List<UploadListElement> getUploadsList() {
        if (this.uploadsList == null) {
            this.uploadsList = new ListWithAutoConstructFlag();
            this.uploadsList.setAutoConstruct(true);
        }
        return this.uploadsList;
    }

    public void setUploadsList(Collection<UploadListElement> uploadsList) {
        if (uploadsList == null) {
            this.uploadsList = null;
            return;
        }
        ListWithAutoConstructFlag uploadsListCopy = new ListWithAutoConstructFlag(uploadsList.size());
        uploadsListCopy.addAll(uploadsList);
        this.uploadsList = uploadsListCopy;
    }

    public ListMultipartUploadsResult withUploadsList(UploadListElement ... uploadsList) {
        if (this.getUploadsList() == null) {
            this.setUploadsList(new ArrayList<UploadListElement>(uploadsList.length));
        }
        for (UploadListElement value : uploadsList) {
            this.getUploadsList().add(value);
        }
        return this;
    }

    public ListMultipartUploadsResult withUploadsList(Collection<UploadListElement> uploadsList) {
        if (uploadsList == null) {
            this.uploadsList = null;
        } else {
            ListWithAutoConstructFlag uploadsListCopy = new ListWithAutoConstructFlag(uploadsList.size());
            uploadsListCopy.addAll(uploadsList);
            this.uploadsList = uploadsListCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListMultipartUploadsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUploadsList() != null) {
            sb.append("UploadsList: " + this.getUploadsList() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUploadsList() == null ? 0 : this.getUploadsList().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResult)) {
            return false;
        }
        ListMultipartUploadsResult other = (ListMultipartUploadsResult)obj;
        if (other.getUploadsList() == null ^ this.getUploadsList() == null) {
            return false;
        }
        if (other.getUploadsList() != null && !other.getUploadsList().equals(this.getUploadsList())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

