/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.auth.policy.conditions.ConditionFactory;
import com.amazonaws.services.glacier.model.StatusCode;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.util.BinaryUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStatusMonitor {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private AmazonSQSClient sqs;
    private AmazonSNSClient sns;
    private String queueUrl;
    private String topicArn;
    private static final Log log = LogFactory.getLog(JobStatusMonitor.class);

    public JobStatusMonitor(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.sqs = new AmazonSQSClient(credentialsProvider, clientConfiguration);
        this.sns = new AmazonSNSClient(credentialsProvider, clientConfiguration);
        this.setupQueueAndTopic();
    }

    public JobStatusMonitor(AmazonSQSClient sqs, AmazonSNSClient sns) {
        this.sqs = sqs;
        this.sns = sns;
        this.setupQueueAndTopic();
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void shutdown() {
        try {
            this.sqs.deleteQueue(new DeleteQueueRequest(this.queueUrl));
        }
        catch (Exception e) {
            log.warn((Object)("Unable to delete queue: " + this.queueUrl), (Throwable)e);
        }
        try {
            this.sns.deleteTopic(new DeleteTopicRequest(this.topicArn));
        }
        catch (Exception e) {
            log.warn((Object)("Unable to delete topic: " + this.topicArn), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobToComplete(String jobId) {
        while (true) {
            List messages = this.sqs.receiveMessage(new ReceiveMessageRequest(this.queueUrl)).getMessages();
            for (Message message : messages) {
                String messageBody = message.getBody();
                if (!messageBody.startsWith("{")) {
                    messageBody = new String(BinaryUtils.fromBase64((String)messageBody));
                }
                try {
                    JsonNode json = MAPPER.readTree(messageBody);
                    String jsonMessage = json.get("Message").asText().replace("\\\"", "\"");
                    json = MAPPER.readTree(jsonMessage);
                    String messageJobId = json.get("JobId").asText();
                    String messageStatus = json.get("StatusMessage").asText();
                    if (!jobId.equals(messageJobId)) continue;
                    try {
                        if (StatusCode.Succeeded.toString().equals(messageStatus)) {
                            return;
                        }
                        if (!StatusCode.Failed.toString().equals(messageStatus)) continue;
                        throw new AmazonClientException("Archive retrieval failed");
                    }
                    finally {
                        this.deleteMessage(message);
                    }
                }
                catch (IOException e) {
                    throw new AmazonClientException("Unable to parse status message: " + messageBody, (Throwable)e);
                }
            }
            this.sleep(30000L);
        }
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ie) {
            throw new AmazonClientException("Archive download interrupted", (Throwable)ie);
        }
    }

    private void deleteMessage(Message message) {
        try {
            this.sqs.deleteMessage(new DeleteMessageRequest(this.queueUrl, message.getReceiptHandle()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupQueueAndTopic() {
        String randomSeed = UUID.randomUUID().toString();
        String queueName = "glacier-archive-transfer-" + randomSeed;
        String topicName = "glacier-archive-transfer-" + randomSeed;
        this.queueUrl = this.sqs.createQueue(new CreateQueueRequest(queueName)).getQueueUrl();
        this.topicArn = this.sns.createTopic(new CreateTopicRequest(topicName)).getTopicArn();
        String queueARN = (String)this.sqs.getQueueAttributes(new GetQueueAttributesRequest(this.queueUrl).withAttributeNames(new String[]{"QueueArn"})).getAttributes().get("QueueArn");
        Policy sqsPolicy = new Policy().withStatements(new Statement[]{new Statement(Statement.Effect.Allow).withPrincipals(new Principal[]{Principal.AllUsers}).withActions(new Action[]{SQSActions.SendMessage}).withResources(new Resource[]{new Resource(queueARN)}).withConditions(new Condition[]{ConditionFactory.newSourceArnCondition((String)this.topicArn)})});
        this.sqs.setQueueAttributes(new SetQueueAttributesRequest(this.queueUrl, this.newAttributes("Policy", sqsPolicy.toJson())));
        this.sns.subscribe(new SubscribeRequest(this.topicArn, "sqs", queueARN));
    }

    private Map<String, String> newAttributes(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of arguments passed.  Input must be specified as: key, value, key, value, ...");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = keyValuePairs[i];
            String value = keyValuePairs[i + 1];
            map.put(key, value);
        }
        return map;
    }
}

