/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.PartListElement;

public class PartListElementJsonMarshaller {
    private static PartListElementJsonMarshaller instance;

    public void marshall(PartListElement partListElement, StructuredJsonGenerator jsonGenerator) {
        if (partListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (partListElement.getRangeInBytes() != null) {
                jsonGenerator.writeFieldName("RangeInBytes").writeValue(partListElement.getRangeInBytes());
            }
            if (partListElement.getSHA256TreeHash() != null) {
                jsonGenerator.writeFieldName("SHA256TreeHash").writeValue(partListElement.getSHA256TreeHash());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PartListElementJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PartListElementJsonMarshaller();
        }
        return instance;
    }
}

