/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CompleteMultipartUploadRequestMarshaller
implements Marshaller<Request<CompleteMultipartUploadRequest>, CompleteMultipartUploadRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CompleteMultipartUploadRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CompleteMultipartUploadRequest> marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        if (completeMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeMultipartUploadRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeMultipartUploadRequest.getArchiveSize() != null) {
            request.addHeader("x-amz-archive-size", StringUtils.fromString((String)completeMultipartUploadRequest.getArchiveSize()));
        }
        if (completeMultipartUploadRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString((String)completeMultipartUploadRequest.getChecksum()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", completeMultipartUploadRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeMultipartUploadRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", completeMultipartUploadRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeMultipartUploadRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{uploadId}", completeMultipartUploadRequest.getUploadId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeMultipartUploadRequest.getUploadId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

