/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.AcceptanceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AcceptMatchRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ticketId;
    private List<String> playerIds;
    private String acceptanceType;

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public AcceptMatchRequest withTicketId(String ticketId) {
        this.setTicketId(ticketId);
        return this;
    }

    public List<String> getPlayerIds() {
        return this.playerIds;
    }

    public void setPlayerIds(Collection<String> playerIds) {
        if (playerIds == null) {
            this.playerIds = null;
            return;
        }
        this.playerIds = new ArrayList<String>(playerIds);
    }

    public AcceptMatchRequest withPlayerIds(String ... playerIds) {
        if (this.playerIds == null) {
            this.setPlayerIds(new ArrayList<String>(playerIds.length));
        }
        for (String ele : playerIds) {
            this.playerIds.add(ele);
        }
        return this;
    }

    public AcceptMatchRequest withPlayerIds(Collection<String> playerIds) {
        this.setPlayerIds(playerIds);
        return this;
    }

    public void setAcceptanceType(String acceptanceType) {
        this.acceptanceType = acceptanceType;
    }

    public String getAcceptanceType() {
        return this.acceptanceType;
    }

    public AcceptMatchRequest withAcceptanceType(String acceptanceType) {
        this.setAcceptanceType(acceptanceType);
        return this;
    }

    public AcceptMatchRequest withAcceptanceType(AcceptanceType acceptanceType) {
        this.acceptanceType = acceptanceType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTicketId() != null) {
            sb.append("TicketId: ").append(this.getTicketId()).append(",");
        }
        if (this.getPlayerIds() != null) {
            sb.append("PlayerIds: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAcceptanceType() != null) {
            sb.append("AcceptanceType: ").append(this.getAcceptanceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptMatchRequest)) {
            return false;
        }
        AcceptMatchRequest other = (AcceptMatchRequest)obj;
        if (other.getTicketId() == null ^ this.getTicketId() == null) {
            return false;
        }
        if (other.getTicketId() != null && !other.getTicketId().equals(this.getTicketId())) {
            return false;
        }
        if (other.getPlayerIds() == null ^ this.getPlayerIds() == null) {
            return false;
        }
        if (other.getPlayerIds() != null && !other.getPlayerIds().equals(this.getPlayerIds())) {
            return false;
        }
        if (other.getAcceptanceType() == null ^ this.getAcceptanceType() == null) {
            return false;
        }
        return other.getAcceptanceType() == null || other.getAcceptanceType().equals(this.getAcceptanceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTicketId() == null ? 0 : this.getTicketId().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerIds() == null ? 0 : this.getPlayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptanceType() == null ? 0 : this.getAcceptanceType().hashCode());
        return hashCode;
    }

    public AcceptMatchRequest clone() {
        return (AcceptMatchRequest)super.clone();
    }
}

