/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.ContainerDefinitionInput;
import com.amazonaws.services.gamelift.model.ContainerOperatingSystem;
import com.amazonaws.services.gamelift.model.ContainerSchedulingStrategy;
import com.amazonaws.services.gamelift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateContainerGroupDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String schedulingStrategy;
    private Integer totalMemoryLimit;
    private Integer totalCpuLimit;
    private List<ContainerDefinitionInput> containerDefinitions;
    private String operatingSystem;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateContainerGroupDefinitionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public CreateContainerGroupDefinitionRequest withSchedulingStrategy(String schedulingStrategy) {
        this.setSchedulingStrategy(schedulingStrategy);
        return this;
    }

    public CreateContainerGroupDefinitionRequest withSchedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy.toString();
        return this;
    }

    public void setTotalMemoryLimit(Integer totalMemoryLimit) {
        this.totalMemoryLimit = totalMemoryLimit;
    }

    public Integer getTotalMemoryLimit() {
        return this.totalMemoryLimit;
    }

    public CreateContainerGroupDefinitionRequest withTotalMemoryLimit(Integer totalMemoryLimit) {
        this.setTotalMemoryLimit(totalMemoryLimit);
        return this;
    }

    public void setTotalCpuLimit(Integer totalCpuLimit) {
        this.totalCpuLimit = totalCpuLimit;
    }

    public Integer getTotalCpuLimit() {
        return this.totalCpuLimit;
    }

    public CreateContainerGroupDefinitionRequest withTotalCpuLimit(Integer totalCpuLimit) {
        this.setTotalCpuLimit(totalCpuLimit);
        return this;
    }

    public List<ContainerDefinitionInput> getContainerDefinitions() {
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinitionInput> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new ArrayList<ContainerDefinitionInput>(containerDefinitions);
    }

    public CreateContainerGroupDefinitionRequest withContainerDefinitions(ContainerDefinitionInput ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinitionInput>(containerDefinitions.length));
        }
        for (ContainerDefinitionInput ele : containerDefinitions) {
            this.containerDefinitions.add(ele);
        }
        return this;
    }

    public CreateContainerGroupDefinitionRequest withContainerDefinitions(Collection<ContainerDefinitionInput> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public CreateContainerGroupDefinitionRequest withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public CreateContainerGroupDefinitionRequest withOperatingSystem(ContainerOperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateContainerGroupDefinitionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateContainerGroupDefinitionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSchedulingStrategy() != null) {
            sb.append("SchedulingStrategy: ").append(this.getSchedulingStrategy()).append(",");
        }
        if (this.getTotalMemoryLimit() != null) {
            sb.append("TotalMemoryLimit: ").append(this.getTotalMemoryLimit()).append(",");
        }
        if (this.getTotalCpuLimit() != null) {
            sb.append("TotalCpuLimit: ").append(this.getTotalCpuLimit()).append(",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: ").append(this.getContainerDefinitions()).append(",");
        }
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerGroupDefinitionRequest)) {
            return false;
        }
        CreateContainerGroupDefinitionRequest other = (CreateContainerGroupDefinitionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSchedulingStrategy() == null ^ this.getSchedulingStrategy() == null) {
            return false;
        }
        if (other.getSchedulingStrategy() != null && !other.getSchedulingStrategy().equals(this.getSchedulingStrategy())) {
            return false;
        }
        if (other.getTotalMemoryLimit() == null ^ this.getTotalMemoryLimit() == null) {
            return false;
        }
        if (other.getTotalMemoryLimit() != null && !other.getTotalMemoryLimit().equals(this.getTotalMemoryLimit())) {
            return false;
        }
        if (other.getTotalCpuLimit() == null ^ this.getTotalCpuLimit() == null) {
            return false;
        }
        if (other.getTotalCpuLimit() != null && !other.getTotalCpuLimit().equals(this.getTotalCpuLimit())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSchedulingStrategy() == null ? 0 : this.getSchedulingStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getTotalMemoryLimit() == null ? 0 : this.getTotalMemoryLimit().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCpuLimit() == null ? 0 : this.getTotalCpuLimit().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateContainerGroupDefinitionRequest clone() {
        return (CreateContainerGroupDefinitionRequest)super.clone();
    }
}

