/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.FleetAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartFleetActionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fleetId;
    private List<String> actions;
    private String location;

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public StartFleetActionsRequest withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public StartFleetActionsRequest withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public StartFleetActionsRequest withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public StartFleetActionsRequest withActions(FleetAction ... actions) {
        ArrayList<String> actionsCopy = new ArrayList<String>(actions.length);
        for (FleetAction value : actions) {
            actionsCopy.add(value.toString());
        }
        if (this.getActions() == null) {
            this.setActions(actionsCopy);
        } else {
            this.getActions().addAll(actionsCopy);
        }
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public StartFleetActionsRequest withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFleetActionsRequest)) {
            return false;
        }
        StartFleetActionsRequest other = (StartFleetActionsRequest)obj;
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        if (other.getFleetId() != null && !other.getFleetId().equals(this.getFleetId())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        return other.getLocation() == null || other.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        return hashCode;
    }

    public StartFleetActionsRequest clone() {
        return (StartFleetActionsRequest)super.clone();
    }
}

